/*
* ============================================================================
*  Name        : qlocationserviceinterface.h
*  Part of     : serviceframework / WRT
*  Description : Interface for location services
*  Version     : %version: 8 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef LOCATIONINTERFACE_H
#define LOCATIONINTERFACE_H

//User include
#include "servicebase.h"

static const char* KILocationId = "com.nokia.ILocation/1.0";

// ILocation interface id
static const ServiceInterfaceInfo KILocation =
{
    KILocationId, 0
};

/**
 * Base class for location service.
 * @lib locationplugin.lib
 * @since x.y
 */
class ILocation : public IServiceBase
{
public:
    /**
     * Get the current position of the device.
     * @param positionOptions position option that is used while
     * retrieving the position information.positionOptions
     * is a  Map described as below:
     * --------------------------------------------------------------------------------------
     *  |Key                | Data type|Description
     *  --------------------------------------------------------------------------------------
     *  |enableHighAccuracy | bool     |Provides a hint that application would like to
     *  |                   |          |receive best possible location estimates.
     *  --------------------------------------------------------------------------------------
     *  |timeout            | double   |Maximum length of time in milliseconds that is allowed
     *  |                   |          |to pass before location estimate is made.
     *  --------------------------------------------------------------------------------------
     *  |maximumAge         | double   |this indicate that application is ready to accept cached
     *  |                   |          |position which is not older than specified maximumAge in
     *  |                   |          |milliseconds.
     *  ----------------------------------------------------------------------------------------
     * @param isLastKnownLocation indicates whether to get the last known location of the device.
     * @return transaction ID in case of success or non-zero symbian error code in case of failure.
     * @emits newPositionData it emits newPositionData signal to notify the result.
     * @since x.y
     */
    virtual QVariant getCurrentPosition(const QMap<QString,QVariant>& positionOptions,
                                        bool isLastKnownLocation) = 0;
    /**
     * Get the current position of the device using special method.
     * @param methodName name of the method to get current position (gps, agps or cellId)
     * @param trId transaction ID of this request.
     * @return error code in case of failure.
     * @emits newPositionData it emits newPositionData signal to notify the result.
     * @since x.y
     */
    virtual QVariant getLocationUsingMethodName(QString methodName,int trId) = 0;

    /**
     * Subscribe to get notification whenever device position changes.
     * @param positionOptions position option that is used while
     * retrieving the position information.positionOptions is a
     * Map described as below:
     * is a  Map described as below:
     * -------------------------------------------------------------------------------------
     *  |Key                | Data type|Description
     *  --------------------------------------------------------------------------------------
     *  |enableHighAccuracy | bool     |Provides a hint that application would like to
     *  |                   |          |receive best possible location estimates.
     *  --------------------------------------------------------------------------------------
     *  |timeout            | double   |Maximum length of time in milliseconds that is allowed
     *  |                   |          |to pass before location estimate is made.
     *  --------------------------------------------------------------------------------------
     *  |maximumAge         | double   |this indicate that application is ready to accept cached
     *  |                   |          |position which is not older than specified maximumAge in
     *  |                   |          |milliseconds.
     *  ----------------------------------------------------------------------------------------
     * @return an unique identifier.This unique identifier can later be used
     * as an argument to clearWatch() to stop getting further notification.
     * @emits newPositionData it emits newPositionData signal to notify the result.
     * @since x.y
     */
    virtual QVariant watchPosition(const QMap<QString,QVariant>& positionOptions) = 0;

    /**
     * Cancel the subscribed watchPosition.It will stop giving further notification
     * of position changes.
     * @param watchId unique number used to identify a previously invoked
     * watchPosition.
     * @since x.y
     * @return 0 in case of success ; non-zero error code otherwise.
     */
    virtual QVariant clearWatch(const int watchId) = 0;

};
Q_DECLARE_INTERFACE(ILocation, KILocationId);

#endif //LOCATIONINTERFACE_H
