# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin

!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}

symbian{
    CONFIG(debug):LOCSVC_SRC_PATH = ./platform/s60/
    CONFIG(debug):LOCSVC_INC_PATH = ./platform/s60/
    CONFIG(release):LOCSVC_SRC_PATH = ./platform/s60/
    CONFIG(release):LOCSVC_INC_PATH = ./platform/s60/
    HEADERS = $$LOCSVC_INC_PATH/locationcoreimp.h \
          $$LOCSVC_INC_PATH/locationservice.h \
          $$LOCSVC_INC_PATH/qlocationservice.h \
          qlocationserviceinterface.h \
          qlocationserviceplugin.h
    SOURCES = $$LOCSVC_SRC_PATH/locationcoreimp.cpp \
          $$LOCSVC_SRC_PATH/locationservice.cpp \
          $$LOCSVC_SRC_PATH/qlocationservice.cpp \
          qlocationserviceplugin.cpp

}

maemo {

  maemo5 {
    DEFINES += __MAEMO__
    CONFIG(debug):LOCSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(debug):LOCSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):LOCSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(release):LOCSVC_INC_PATH = ./platform/maemo5/

    CONFIG(release):DEFINES += QT_NO_DEBUG_OUTPUT

    HEADERS = ./qlocationserviceinterface.h \
              ./qlocationserviceplugin.h  \
               $$LOCSVC_INC_PATH/qlocationservice.h \
               $$LOCSVC_INC_PATH/qlocationengine.h \
               $$LOCSVC_INC_PATH/timeObserver.h \
               $$LOCSVC_INC_PATH/emitAsyncTask.h

    SOURCES =  ./qlocationserviceplugin.cpp \
               $$LOCSVC_SRC_PATH/qlocationservice.cpp \
               $$LOCSVC_SRC_PATH/qlocationengine.cpp \
               $$LOCSVC_SRC_PATH/timeObserver.cpp \
               $$LOCSVC_SRC_PATH/emitAsyncTask.cpp

  } else {
    # maemo6
    DEFINES += __MAEMO__
    CONFIG(debug):LOCSVC_SRC_PATH = ./platform/maemo/
    CONFIG(debug):LOCSVC_INC_PATH = ./platform/maemo/
    CONFIG(release):LOCSVC_SRC_PATH = ./platform/maemo/
    CONFIG(release):LOCSVC_INC_PATH = ./platform/maemo/

    HEADERS = ./qlocationserviceinterface.h \
              ./qlocationserviceplugin.h  \
               $$LOCSVC_INC_PATH/qlocationservice.h \
               $$LOCSVC_INC_PATH/timeObserver.h \
               $$LOCSVC_INC_PATH/getCachedPosTask.h \
               $$LOCSVC_INC_PATH/getMethodPosTask.h

    SOURCES =  $$LOCSVC_SRC_PATH/qlocationservice.cpp \
               $$LOCSVC_SRC_PATH/timeObserver.cpp \
               $$LOCSVC_SRC_PATH/getCachedPosTask.cpp \
               $$LOCSVC_SRC_PATH/getMethodPosTask.cpp \
               ./qlocationserviceplugin.cpp
  }
}

TARGET = WrtApiLocation
include(../cwrtservice.pri)

symbian {
    LIBS += -leuser \
            -leikcoctl \
            -lbafl \
            -lefsrv \
            -lPlatformEnv \
            -lhal \
            -llbs

    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x20026159

    VERSION = 3.0.0

    TARGET.sources = ./descriptionxml/locationserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}

maemo {

  maemo5 {
    CONFIG += mobility
    MOBILITY += location

    # Build against wrt-dev package
    cwrt-services {
        INCLUDEPATH -= ../../../inc
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }

    INCLUDEPATH += $$CWRT_INCLUDE \
        $$LOCSVC_INC_PATH \
        /usr/include

  } else {
    # maemo6
    LIBS += /usr/lib/libQtLocation.so

    INCLUDEPATH += $$CWRT_INCLUDE \
        $$LOCSVC_INC_PATH \
        /usr/include/qt4/ \
        /usr/include/qt4/QtLocation
  }
}
