/*
* ============================================================================
*  Name        : timeObserver.h
*  Part of     : serviceframework / WRT
*  Description : Qt class for Location service
*  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef TIMEOBSERVER_H_
#define TIMEOBSERVER_H_

#include <QObject>
#include <QVariant>
#include <QTimer>

// This object is created for emitting asyncronous signal when time is out.

class timeObserver: public QObject
{
    Q_OBJECT

public:
    timeObserver(qint32 transaction_id, QVariant aTimerOption);
    virtual ~timeObserver();
    virtual void run();

signals:
    void timeOutCB(qint32 transId);

private slots:
    void timeOut();

private:
    qint32 m_trId;
    QVariant timerOption;
    QTimer* timeOutTimer;
};
#endif /* TIMEOBSERVER_H_ */
