/*
* ============================================================================
*  Name        : qlocationengine.cpp
*  Part of     : serviceframework / WRT
*  Description : Qt class for Location service
*  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QDebug>
#include "qlocationengine.h"

LocationEngine* LocationEngine::pinstance = NULL;

LocationEngine* LocationEngine::getInstance(LocationProvider *parent)
{
    if (!pinstance)
    {
        pinstance = new LocationEngine(parent);
    }
    return pinstance;
}

void LocationEngine::freeResources()
{
    if (pinstance)
    {
        delete pinstance;
        pinstance = NULL;
    }
}

LocationEngine::LocationEngine(LocationProvider *provider)
{
    m_positionInfoSource = QGeoPositionInfoSource::createDefaultSource(provider);
    if (m_positionInfoSource)
    {
        connect(m_positionInfoSource, SIGNAL(positionUpdated(const QGeoPositionInfo&)),
                provider, SLOT(posUpdated(const QGeoPositionInfo&)));
    }
    else
    {
        qDebug() << "not able to create positionsource";
    }
}

LocationEngine::~LocationEngine()
{
    disconnect(m_positionInfoSource,  0, 0, 0);
    if (m_positionInfoSource)
    {
        delete m_positionInfoSource;
    }
}

QGeoPositionInfoSource* LocationEngine::getPositionInfoSource()
{
    return m_positionInfoSource;
}
