/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include "fsutilities.h"
#include "fsconstants.h"

Utilities::Utilities()
    {
    }

Utilities::~Utilities()
    {
    }

// --------------------------------------------------------------------
// Utilities::ReturnMap()
// Creates and returns the ouput map.
// This is a synchronous method.
// --------------------------------------------------------------------
FileSystemMap Utilities::ReturnMap(int errorCode, QString errorMessage,QVariant data)
    {
    FileSystemMap ReturnMap;
    ReturnMap.clear();
    ReturnMap.insert(ERRORCODE_STR,errorCode);
    ReturnMap.insert(ERRORMESSAGE_STR,errorMessage);
    if ( data != DATA_NOT_SET )
        ReturnMap.insert(DATA_STR,data);

    return ReturnMap;
    }
