# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin

!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}

INCLUDEPATH += ../../../inc
HEADERS = fsmountpointinterface.h \
    fsioworker.h \
    fsutilities.h \
    fsworker.h \
    filesystemserviceplugin.h \
    filesystemservice.h \
    filesysteminterface.h \
    fserrorcodes.h \    
    fsconstants.h 
    
CONFIG(debug):HEADERS += fslog.h 
    
    
SOURCES = fsioworker.cpp \
    fsutilities.cpp \
    fsworker.cpp \
    filesystemserviceplugin.cpp \
    filesystemservice.cpp 
    
CONFIG(debug): SOURCES += fslog.cpp
    
TARGET = WrtApiFileSystem

include(../cwrtservice.pri)

INCLUDEPATH += $$CWRT_INCLUDE

CONFIG(debug):DEFINES += DEBUG_MODE
symbian { 
		INCLUDEPATH += platform/s60 \
                       $$MW_LAYER_SYSTEMINCLUDE
    			   
    HEADERS += platform/s60/fsplatform.h\
    		   platform/s60/fsmemcardnotifier.h
    					 
    SOURCES += platform/s60/fsplatform.cpp\
    		   platform/s60/fsmemcardnotifier.cpp
    					 
    LIBS += -lefsrv -lPlatformEnv -lbafl
    TARGET.CAPABILITY = ALL -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x2002614B
    VERSION = 3.0.0
    
    filesystemserviceplugin.sources = ./descriptionxml/filesystemserviceplugin.xml
    filesystemserviceplugin.path = /private/102829B8/import
    DEPLOYMENT += filesystemserviceplugin
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}
maemo {
    DEFINES += __MAEMO__
    
    # Build against wrt-dev package
    cwrt-services {
        LIBS += -L/usr/lib -lWrtSecurityManager
        INCLUDEPATH -= ../../../inc
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }

    INCLUDEPATH += platform/maemo
    HEADERS += platform/maemo/fsplatform.h
    					 
    SOURCES += platform/maemo/fsplatform.cpp
}
