/*
* ============================================================================
*  Name        : refserviceinterface.h
*  Part of     : serviceframework / WRT
*  Description : Interface for reference service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef REFERENCESERVICEINTERFACE_H
#define REFERENCESERVICEINTERFACE_H

#include <QtCore>
#include "servicebase.h"

static const char* KIRefTypeTestId = "com.nokia.IRefTypeTest/1.0";

// ITypeTest interface id
static const ServiceInterfaceInfo KIRefTypeTestInfo =
{
    KIRefTypeTestId, 0
};

class IRefTypeTest : public IServiceBase
{
public:
    virtual QVariant testMapSync(const QVariant& aObject) = 0;
    virtual QVariant testListSync(const QVariant& aArray) = 0;
    virtual void testIntAsync(int aInt) = 0;
};
Q_DECLARE_INTERFACE(IRefTypeTest, KIRefTypeTestId);



static const char* KIRefTypeTestV2Id = "com.nokia.IRefTypeTest/2.0";

// ITypeTest interface V2.0 id
static const ServiceInterfaceInfo KIRefTypeTestV2Info =
{
    KIRefTypeTestV2Id, 0
};

class IRefTypeTestV2 : public IServiceBase
{
public:
    virtual void testIntAsync(int aInt) = 0;
    virtual int testIntSync(int aInt) = 0;
};
Q_DECLARE_INTERFACE(IRefTypeTestV2, KIRefTypeTestV2Id);
#endif //REFERENCESERVICEINTERFACE_H
