// Declare the service object 
var so_v1;
var so_v2;
var factory;
var connectId;
var asyncVal;

function initServiceObject() 
{
    try {
        factory = document.getElementById('serviceFactory');
        try {
            so_v1 = factory.getServiceObject("referenceService","com.nokia.IRefTypeTest","1.0");
            if (factory.getLastErrCode() != 0) { 
                throw factory.getLastErrDescription();
            }
        } catch (e) {
            alert(factory.getLastErrDescription());
        }
        try {
            so_v2 = so_v1.getInterface("com.nokia.IRefTypeTest","2.0");
            if (so_v1.getLastErrCode() != 0) {
                throw so_v1.getLastErrDescription();
            }
        } catch (e) {
            alert(so_v1.getLastErrDescription());
        }
    } catch (e) {
        alert("Service framework plugin is not loaded!");
    }

}

function testInt() 
{  
    function testIntAsyncCallback(ret) {
        if(asyncVal === ret) {
            document.getElementById("testIntAsyncResult").value="Passed";
        } else {
            document.getElementById("testIntAsyncResult").value="Failed";  
        }
        so_v1.removeEventListener(connectId);
    }
    connectId = so_v1.addEventListener("testIntAsyncCallback(int)", testIntAsyncCallback);
    asyncVal = 123;
    so_v1.testIntAsync(asyncVal);
}

function testIntSyncV2() 
{  
    if(123 === so_v2.testIntSync(123)) {
        document.getElementById("testIntSyncResultV2").value="Passed";
    } else {
        document.getElementById("testIntSyncResultV2").value="Failed";  
    }
}

function testIntAsyncV2() 
{  
    function testIntAsyncCallbackV2(ret) {
        if(asyncVal === ret) {
            document.getElementById("testIntAsyncResultV2").value="Passed";
        } else {
            document.getElementById("testIntAsyncResultV2").value="Failed";  
        }
        so_v2.removeEventListener(connectId);
    }
    connectId = so_v2.addEventListener("testIntAsyncCallback(int)", testIntAsyncCallbackV2);
    asyncVal = 123;
    so_v2.testIntAsync(asyncVal);
}

function testObject() 
{
    // Setting up object to test
    var inVar = new Object();
    inVar.level_0_Int = 123;
    inVar.level_0_Double = -789.456;
    inVar.level_0_Bool = true;
    inVar.level_0_String = "Hello World";
    inVar.level_0_Object = new Object();
    inVar.level_0_Object.level_1_object = new Object();
    inVar.level_0_Object.level_1_object.level_2_Int = 5678;
    inVar.level_0_Object.level_1_object.level_2_Object = new Object();
    inVar.level_0_Object.level_1_object.level_2_Object.level_3_Int = 3;
    
    // Sync test
    var ret = so_v1.testMapSync(inVar);
    
    if(compareObjects(inVar, ret)) {
        document.getElementById("testObjectSyncResult").value="Passed";
    } else {
        document.getElementById("testObjectSyncResult").value="Failed";
    }
}

function testArray()
{
    // Sync test
    var inVar = new Array("Hello World",123456,true);
    var ret = so_v1.testListSync(inVar);
    var isEqual = true;
    for(i=0; i<inVar.length; i++) {
        if(ret[i] != inVar[i]) {
            isEqual = false;
            break;
        }
            
    }
    if(isEqual) {
        document.getElementById("testArraySyncResult").value="Passed";
    } else {
        document.getElementById("testArraySyncResult").value="Failed";
    }
}

function testAll()
{
    testObject();
    testArray();
    testInt();
    testIntSyncV2();
    testIntAsyncV2();
}

function clearAll()
{
    var inputs, input;
    inputs = document.getElementsByTagName("input");
    for( i=0, input; input=inputs[i++]; ) {
        if (input.type == "text") {
            input.value ='';
        }
    }
}

function compareObjects(a, b)
{
    for (var key in a)  {
        if(a[key] == a.toString()) {
            if(!compareObjects(a[key], b[key])) {
                return false;
            }
        } else if(a[key]!=b[key]) {
            return false;
        }
    }
    return true;
}

