# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

######################################################################
#
# Common Web Run Time Service Provider - common QMake settings for
# Maemo and Linux
#
######################################################################

CWRT_INCLUDE = /usr/include/cwrt
CWRT_INSTALL_LIB_DIR = /usr/lib/cwrt
CWRT_INSTALL_SERVICE_DIR = /usr/lib/cwrt/serviceproviders
USR_SHARE_DIR = /usr/share

#
# Target compilation target (i386/armel)
# Used for distinguish armel and i386 compilations, meaning
# that object files are stored into target architecture specific folders.
#
TARGET_ARCH=$$system(dpkg --print-architecture)
message("Build target is $$TARGET_ARCH")

CONFIG(debug, debug|release) {
    SUBDIRPART = debug
} else {
    SUBDIRPART = release
}

isEmpty( TARGET_ARCH ) {
    message( "Empty target arch is platform" )
    TARGET_ARCH=platform
    }

message( "Object target is $$TARGET_ARCH" )

BUILD_DIR = ./build/$$SUBDIRPART/$$TARGET_ARCH
DESTDIR = $$BUILD_DIR/bin
OBJECTS_DIR = $$BUILD_DIR
MOC_DIR = $$BUILD_DIR
RCC_DIR = $$BUILD_DIR
UI_DIR =  $$BUILD_DIR
TEMPDIR = $$BUILD_DIR/tmp

# Definition of common "relative" variables
CWRT_INSTALL_QTWEBKIT_DIR = $$CWRT_INSTALL_LIB_DIR/qtwebkit

CWRT_WRT_INCLUDE = $$CWRT_INCLUDE/wrt
WRT_SECURITY_HEADERS = $$CWRT_WRT_INCLUDE/security
WRT_SERVICEFW_HEADERS = $$CWRT_WRT_INCLUDE/servicefw
WRT_SERVICEHANDLER_HEADERS = $$WRT_SERVICEFW_HEADERS/servicehandler
WRT_USERAGENT_HEADERS = $$CWRT_WRT_INCLUDE/utilities/UserAgent
WRT_WIDGETMANAGER_HEADERS = $$CWRT_WRT_INCLUDE/widgetmanager/src
WRT_W3CXMLPARSER_HEADERS = $$WRT_WIDGETMANAGER_HEADERS/W3CXmlParser

WRT_IPC_HEADERS  =  $$CWRT_WRT_INCLUDE/ipc/serviceipc \
                    $$CWRT_WRT_INCLUDE/ipc/serviceipcserver

DEPENDPATH += .
INCLUDEPATH +=  ./ \
                $$WRT_SECURITY_HEADERS \
                $$WRT_SERVICEFW_HEADERS \
                $$WRT_SERVICEHANDLER_HEADERS \
                $$WRT_USERAGENT_HEADERS \
                $$WRT_WIDGETMANAGER_HEADERS \
                $$WRT_W3CXMLPARSER_HEADERS \
                $$WRT_IPC_HEADERS

QMAKE_RPATHDIR = $$CWRT_INSTALL_LIB_DIR \
                 $$CWRT_INSTALL_SERVICE_DIR \
                 $$CWRT_INSTALL_QTWEBKIT_DIR \
                 $$DESTDIR \
                 $$QMAKE_RPATHDIR
QMAKE_LIBDIR = $$CWRT_INSTALL_LIB_DIR \
               $$CWRT_INSTALL_QTWEBKIT_DIR \
               $$QMAKE_LIBDIR

LIBS += -L$$CWRT_INSTALL_LIB_DIR \
        -L$$CWRT_INSTALL_SERVICE_DIR \
        -L$$DESTDIR

EXPORT_DIR = /usr/include/cwrt/wrt/serviceproviders/

CONFIG(gcov)   {
   LIBS           += -lgcov
   QMAKE_CXXFLAGS += -fprofile-arcs -ftest-coverage
}

# Install target
target.path = $$CWRT_INSTALL_SERVICE_DIR

# Install desritption XML
xml.path = $$CWRT_INSTALL_SERVICE_DIR/install/
xml.files = ./descriptionxml/$${TARGET}.xml

# Install tests.xml
testxml.path = $$USR_SHARE_DIR/$${PACKAGE}-tests
testxml.files = ./tests.xml

# Install headers 
headers.path = $$EXPORT_DIR
headers.files = $$EXPORT_FILES

INSTALLS += target xml testxml headers
