/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef GETGROUPSTASK_H_
#define GETGROUPSTASK_H_

#include <QObject>
#include <QRunnable>
#include <QMutex>
#include <QWaitCondition>
// Qt Mobility header
#include <qtcontacts.h>

using namespace QTM_NAMESPACE;

/**
 * An async task for invoking Contacts::getGroups().
 */
class GetGroupsTask: public QObject, public QRunnable {

    Q_OBJECT

public:
    GetGroupsTask(qint32 trId);
    virtual ~GetGroupsTask();

    virtual void run();

    void finishTask();

Q_SIGNALS:
    /**
     * Signals a getGroupsIds ready state.
     * @param a list that contains all groups.
     */
    void groupInfos(GetGroupsTask* aTask,QList<QContact>, qint32, qint32);

private:

    qint32 m_trId;
    QMutex iMutex;
    QMutex iMutex2;
    QWaitCondition iWait;
};

#endif /* GETGROUPSTASK_H_ */
