/*
 * ============================================================================
 *  Name        : qcommlogmodel.h
 *  Part of     : serviceframework / WRT
 *  Description : Model Event class for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef COMMHISTORYMODEL_H
#define COMMHISTORYMODEL_H

#include <QObject>
#include <QVariant>
#include <QString>
#include <QMap>
#include <QList>
#include <eventlogger.h>

#include "qcommlogevent.h"


class CommHistoryModel: public QObject
{
    Q_OBJECT;
public:
    CommHistoryModel();
    ~CommHistoryModel();

    //Mapping to Map from Event class
    static QVariantMap fillMessageData(const Event &aEvent);
    //Get event by id
    static bool getEvent(RTComEl *dbElement, int aEventId, Event &aEvent);
    //Get some events from db
    virtual bool getEvents(RTComEl */*el*/) {return true;}
    virtual bool acceptsEvent(const Event &event) const {Q_UNUSED(event); return true;}
    //Return event tree
    QList<QVariantMap> getEventTree(){return m_eventTree;}
    //Mapping to Event class from RTCOmElEvent structure
    static void fillEventFromModel(RTComElEvent *model, Event &event);
protected:
    QString m_pluginName;
    //Events list
    QList<QVariantMap> m_eventTree;
private:
    QString newObjectPath();
    static uint m_modelSerial;
};
//-----------------CommHistorySmsModel---------------------------------------------------
class CommHistorySmsModel: public CommHistoryModel
{
public:
    CommHistorySmsModel();
    ~CommHistorySmsModel();

    virtual bool getEvents(RTComEl *dbElement);

    virtual bool acceptsEvent(const Event &event) const;
};

//-----------------CommHistoryCallModel---------------------------------------------------
class CommHistoryCallModel: public CommHistoryModel
{
public:
    CommHistoryCallModel();
    ~CommHistoryCallModel();

    virtual bool getEvents(RTComEl *dbElement);

    virtual bool acceptsEvent(const Event &event) const;
};
#endif // COMMHISTORYMODEL_H
