/*
 * ============================================================================
 *  Name        : qcommloggetlisttask.h
 *  Part of     : serviceframework / WRT
 *  Description : Runnable object for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef GET_COMM_LOG_LIST_TASK_H
#define GET_COMM_LOG_LIST_TASK_H

#include <QRunnable>
#include <QObject>
#include <QVariantList>
#include <QMutex>
#include <QWaitCondition>

#include "qcommlogfilter.h"
#include "qcommlogcallandsmsmodel.h"


class GetCommLogListTask : public QObject, public QRunnable
{
    Q_OBJECT

public:
    GetCommLogListTask(qint32 transaction_id, const CommLogFilter& aFilter, CommCallAndSMSModel& aModel);
    ~GetCommLogListTask();
    void finishTask();
    //Take messages from DB and put them into list
    int getMessagesNow(QVariantList& aResults);

Q_SIGNALS:
    //signal about getting all events.
    void signalGetCommLogListCb(GetCommLogListTask* aTask, qint32 aTransactionId, int aErrorCode, QVariantList aList);

private:
    //run task
    void run();
private:
    qint32 iTransactionId;
    CommLogFilter iFilter;
    QVariantList iEvents;
    QMutex iMutex;
    QMutex iMutex2;
    QWaitCondition iWait;
    CommCallAndSMSModel& iModel;
};

#endif //GET_COMM_LOG_LIST_TASK_H
