/*
 * ============================================================================
 *  Name        : qcommloggetlisttask.cpp
 *  Part of     : serviceframework / WRT
 *  Description : Runnable object for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QString>
#include <QDebug>
#include <QDateTime>

#include "qcommloggetlisttask.h"
#include "qcommlogerrorcodes.h"
#include "qcommlogkeyconstants.h"


class qEventSorter
{
public:
    qEventSorter() {}
    bool operator()(const QVariant &t1, const QVariant &t2) const
    {
        return (t1.toMap().value(KLTime).toDateTime() > t2.toMap().value(KLTime).toDateTime());
    }
};


GetCommLogListTask::GetCommLogListTask(qint32 transaction_id, const CommLogFilter& aFilter, CommCallAndSMSModel& aModel)
: iTransactionId(transaction_id), iFilter(aFilter), iModel(aModel)
{
    qDebug() << "GetCommLogListTask::GetCommLogListTask" << transaction_id;
}

GetCommLogListTask::~GetCommLogListTask()
{
    qDebug()<<__PRETTY_FUNCTION__;
}

void GetCommLogListTask::finishTask()
{
    qDebug() << "GetCommLogListTask::finishTask. Id=" << iTransactionId;
    iMutex2.lock();
    iMutex2.unlock();
    iWait.wakeAll();
    qDebug() << "GetCommLogListTask::finishTask end";
}

int GetCommLogListTask::getMessagesNow(QVariantList& aResults)
{
    QVariantList tmp;
    QVariantList* tmpRef = &aResults;

    if ((iFilter.FilterFlags() & CommLogFilter::ENumberOfLogs))
    {
        tmpRef = &tmp;
    }
    int res = NO_ERROR;
    QString errMsg;
    qDebug() << __FUNCTION__;

    bool getSuccess = iModel.getEvents(iFilter, *tmpRef, res, errMsg);
    if (getSuccess)
    {
        qDebug() << "[commlog]: Get events OK. Count = " << tmpRef->count();
        qSort(tmpRef->begin(), tmpRef->end(), qEventSorter());

        //reduce to specified number of logs
        if ((iFilter.FilterFlags() & CommLogFilter::ENumberOfLogs))
        {
            qDebug() << "[commlog]: Reduce results to " << iFilter.NumberOfLogs() << " items";
            for (int i = 0; i < iFilter.NumberOfLogs() && i < tmpRef->count(); i++)
            {
                aResults.append(tmpRef->at(i));
            }
            foreach (QVariant var, aResults)
            {
                qDebug() << var.toMap();
            }
        }
    }

    return res;
}

void GetCommLogListTask::run()
{
    qDebug() << "GetCommLogListTask::run(): transaction id=" << iTransactionId;

    int err = getMessagesNow(iEvents);

    iMutex2.lock();
    emit signalGetCommLogListCb(this, iTransactionId, err, iEvents);
    iMutex.lock();
    iMutex2.unlock();
    iWait.wait(&iMutex);
    iMutex.unlock();
    qDebug() << "GetCommLogListTask::run() - end";
}
