/*
 * ============================================================================
 *  Name        : qcommlogfilter.h
 *  Part of     : serviceframework / WRT
 *  Description : Filter class for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _COMM_LOG_FILTER_H
#define _COMM_LOG_FILTER_H

#include <QMap>
#include <QStringList>
#include <QString>
#include <QDateTime>
#include <QVariant>
#include <QHash>


class CommLogFilter
{
public :
    enum FilterFlags
    {
        ENone =          0x000,
        EType =          0x001,
        ERecent =        0x002,
        EDirectionFlag = 0x004,
        EPhoneNumber =   0x008,
        EContactName =   0x010,
        ENumberOfLogs =  0x020,
        EStartTime =     0x040,
        EEndTime =       0x080,
        EAll =           0xFFF
    };

    CommLogFilter();
    ~CommLogFilter();

    bool parseFromMap(const QVariantMap& aMap, int &aErrorCode, QString& aErrorMessage);
    int EventType() const {return iEventType;}
    bool IsRecent() const {return iRecent;}
    qulonglong DirectionFlag() const {return iDirectionFlag;}
    QString PhoneNumber() const {return iPhoneNumber;}
    QString ContactName() const {return iContactName;}
    int NumberOfLogs() const {return iNumberOfLogs;}
    QDateTime StartTime() const {return iStartTime;}
    QDateTime EndTime() const {return iEndTime;}
    uint FilterFlags() const {return iFilterFlags;}

    //convinient functions
    bool allowSms() const;
    bool allowIncoming() const;
    bool allowOutgoing() const;
    bool allowMissed() const;
    bool allowSmsInbox() const {return allowSms() && allowIncoming();}
    bool allowSmsOutbox() const {return allowSms() && allowOutgoing();}
    bool allowCall() const;

    bool allowStartTime(const QDateTime& aEventTime) const;
    bool allowEndTime(const QDateTime& aEventTime) const;

    bool allowPhoneNumber(const QString& aPhoneNumber) const;
    bool allowContactName(const QString& aContactName) const;


private:
    int iEventType;
    bool iRecent;
    qulonglong iDirectionFlag;
    QString iPhoneNumber;
    QString iContactName;
    int iNumberOfLogs;
    QDateTime iStartTime;
    QDateTime iEndTime;
    uint iFilterFlags;
    QHash<QString, qulonglong> iHashTable;
};

#endif //_COMM_LOG_FILTER_H
