/*
 * ============================================================================
 *  Name        : qcommlogerrorcodes.h
 *  Part of     : serviceframework / WRT
 *  Description : Common error codes for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCOMMLOGERRORCODES_H_
#define QCOMMLOGERRORCODES_H_

#include <QString>

//General Error Messages
const QString KMissingArgErr("A mandatory argument in a method is missing");
const QString KInvalidArgErr("Argument passed is of different type than what is expected");
const QString KNotSupported("Not supported error");
const QString KDataExists("Data already exists");
const QString KDataNotFound("Data entry not found");
const QString KNotAllowedErr("user doesnt have permission to access specified content");
const QString KServiceInUse("Service already in use");
const QString KGeneralErr("General error");
const QString KCatIdNotFound("supplied id does not exist");
const QString KMissingName("Name must be supplied");
const QString KInvalidFormatData("The data format in source file is invalid");

enum deviceError
        {
        NO_ERROR = 0,
        MISSING_ARG_ERR = 1,
        INVALID_ARG_ERR  =2,
        NOT_SUPPORTED_ERR =3,
        TIMEOUT_ERR   = 100,
        DATA_NOT_FOUND_ERR ,
        DATA_ALREADY_EXISTS_ERR ,
        SERVICE_BUSY_ERR  ,
        SERVICE_IN_USE_ERR ,
        DATA_OUT_OF_RANGE_ERR ,
        NOT_ALLOWED_ERR ,
        SIZE_EXCEEDED_ERR ,
        INVALID_URI_ERR ,
        URI_NOT_FOUND_ERR ,
        URI_ALREADY_EXISTS_ERR ,
        GENERAL_ERROR
        };


#endif /* QCOMMLOGERRORCODES_H_ */
