# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin
!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}
symbian {
	CONFIG(debug):CALENSVC_SRC_PATH = ./platform/s60/
	CONFIG(debug):CALENSVC_INC_PATH = ./platform/s60/
	CONFIG(release):CALENSVC_SRC_PATH = ./platform/s60/
	CONFIG(release):CALENSVC_INC_PATH = ./platform/s60/
	HEADERS = $$CALENSVC_INC_PATH/addentry.h \
					$$CALENSVC_INC_PATH/asyncreqobserver.h \
					$$CALENSVC_INC_PATH/calendarconstants.h \
					$$CALENSVC_INC_PATH/calendardeleteentry.h \
					$$CALENSVC_INC_PATH/calendarexport.h \
					$$CALENSVC_INC_PATH/calendargetlist.h \
					$$CALENSVC_INC_PATH/calendarheader.h \
					$$CALENSVC_INC_PATH/calendarimport.h \
					$$CALENSVC_INC_PATH/calendariterableimpl.h \
					$$CALENSVC_INC_PATH/calendarnotify.h \
					$$CALENSVC_INC_PATH/calendarservice.h \
					$$CALENSVC_INC_PATH/entryattributes.h \
					$$CALENSVC_INC_PATH/calendarstarteditor.h \
					$$CALENSVC_INC_PATH/qcalendarcallback.h \
					$$CALENSVC_INC_PATH/qcalendarservice.h \
					$$CALENSVC_INC_PATH/qcalendariterator.h \
					$$CALENSVC_INC_PATH/qcalendarconstants.h \
    			./qcalendarserviceplugin.h \
    			./qcalendarserviceinterface.h

	SOURCES = $$CALENSVC_SRC_PATH/calendarheader.cpp \
					$$CALENSVC_SRC_PATH/calendarservice.cpp \
					$$CALENSVC_SRC_PATH/calendarnotify.cpp \
					$$CALENSVC_SRC_PATH/calendardeleteentry.cpp \
					$$CALENSVC_SRC_PATH/calendarimport.cpp \
					$$CALENSVC_SRC_PATH/calendarexport.cpp \
					$$CALENSVC_SRC_PATH/addentry.cpp \
					$$CALENSVC_SRC_PATH/entryattributes.cpp  \
					$$CALENSVC_SRC_PATH/calendargetlist.cpp \
					$$CALENSVC_SRC_PATH/calendarstarteditor.cpp \
					$$CALENSVC_SRC_PATH/qcalendarcallback.cpp \
    			$$CALENSVC_SRC_PATH/qcalendarservice.cpp \
    			$$CALENSVC_SRC_PATH/qcalendariterator.cpp \
    			./qcalendarserviceplugin.cpp
}
maemo {
    maemo5 {
        DEFINES += __MAEMO__
        CONFIG(debug):CALENSVC_SRC_PATH = ./platform/maemo5/
        CONFIG(debug):CALENSVC_INC_PATH = ./platform/maemo5/
        CONFIG(release):CALENSVC_SRC_PATH = ./platform/maemo5/
        CONFIG(release):CALENSVC_INC_PATH = ./platform/maemo5/
        HEADERS = $$CALENSVC_INC_PATH/qcalendarservice.h \
            		$$CALENSVC_INC_PATH/qcalendarhelper.h \
            		$$CALENSVC_INC_PATH/qgetlisttask.h \
            		$$CALENSVC_INC_PATH/qcalendariterator.h \
            		$$CALENSVC_INC_PATH/qcalendarconstants.h \
            		./qcalendarserviceplugin.h \
            		./qcalendarserviceinterface.h
        SOURCES = $$CALENSVC_SRC_PATH/qcalendarservice.cpp \
            		$$CALENSVC_SRC_PATH/qcalendarhelper.cpp \
            		$$CALENSVC_SRC_PATH/qgetlisttask.cpp \
            		$$CALENSVC_SRC_PATH/qcalendariterator.cpp \
            		./qcalendarserviceplugin.cpp
    }
    else {
        DEFINES += __MAEMO__
    
    	CONFIG(debug):CALENSVC_SRC_PATH = ./platform/maemo/
    	CONFIG(debug):CALENSVC_INC_PATH = ./platform/maemo/
    	CONFIG(release):CALENSVC_SRC_PATH = ./platform/maemo/
    	CONFIG(release):CALENSVC_INC_PATH = ./platform/maemo/
    	HEADERS = $$CALENSVC_INC_PATH/qcalendarservice.h \
					$$CALENSVC_INC_PATH/qcalendarhelper.h \
        			$$CALENSVC_INC_PATH/qgetlisttask.h \
        			$$CALENSVC_INC_PATH/qcalendariterator.h \
        			$$CALENSVC_INC_PATH/qcalendarconstants.h \
        			./qcalendarserviceplugin.h \
        			./qcalendarserviceinterface.h

        SOURCES = $$CALENSVC_SRC_PATH/qcalendarservice.cpp \
        			$$CALENSVC_SRC_PATH/qcalendarhelper.cpp \
        			$$CALENSVC_SRC_PATH/qgetlisttask.cpp \
        			$$CALENSVC_SRC_PATH/qcalendariterator.cpp \
        			./qcalendarserviceplugin.cpp
    }
}
TARGET = WrtApiCalendar
include(../cwrtservice.pri)
symbian { 
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x2002614C
    LIBS += -lefsrv \
        -leuser \
        -lestor \
	-lcone \
        -leikcore \
        -lavkon \
        -lbafl \
        -lplatformenv \
        -lcalenimp \
        -lcalinterimapi \
        -lapgrfx \
        -lapparc \
        -lws32	\        
        -lCalenInterimUtils2 
        
     VERSION = 3.0.0
        
    TARGET.sources = ./descriptionxml/calendarserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
    #QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}
maemo {
    maemo5 {
        LIBS += -L$$MAEMO_HOME/maemowrt
        LIBS += -lcalendar_backend
        LIBS += -lical
        LIBS -= -lsecmgr
        LIBS += -L/usr/lib -lWrtSecurityManager
        INCLUDEPATH += $$CWRT_INCLUDE \
            $$MAEMO_HOME/services \
            $$MAEMO_HOME/utils \
            /usr/include/calendar-backend \
            /usr/include/libical \
            $$CALENSVC_INC_PATH \
            /usr/include/Qt/ \
            /usr/include/cwrt/security \
            /usr/include/cwrt/servicefw
    }
    else {
        LIBS += -L$$MAEMO_HOME/maemowrt
        #LIBS += -lmaemowrt
        LIBS += -lmaemokcal
        INCLUDEPATH += $$CWRT_INCLUDE \
            $$MAEMO_HOME/services \
            $$MAEMO_HOME/utils \
            /usr/include/kcal \
            $$CALENSVC_INC_PATH \
            /usr/include/qt4/
    }
}
