/*
 * ============================================================================
 *  Name        : qgetlisttask.h
 *  Part of     : serviceframework / WRT
 *  Description : getlist runnable object class for Calendar service
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QGETLISTTASK_H
#define QGETLISTTASK_H

#include <QMap>
#include <QObject>
#include <QRunnable>
#include <QString>
#include <QVariant>

#include "qcalendarservice.h"

//GetListTask class. Implements sync and async methods of getList() task
class GetListTask: public QObject, public QRunnable 
{
    Q_OBJECT
public:
    //constructor
    GetListTask(CMulticalendar * multiCalendar, const QMap<QString,QVariant>& matchCriteria, qint32 trId);
    //destructor
    virtual ~GetListTask();
    //async task for invoking getList()
    virtual void run();
    //getList() implementation
    qint32 getList(QList<QVariantMap> * mapList);

signals:
    //signal sent to QCalendarService with result of getList() operation
    void listOfCalendarEntries(const QList<QVariantMap> *, qint32, qint32);

private:
    //fetch entries from calendar db by specified type
    void fetchEntriesByType(QString type, QList<QVariantMap>* mapList);
    //fetch entries with Event type from db by specified time range
    void fetchEventsByRange(QList<QVariantMap>* mapList, QDateTime rangeBegin, QDateTime rangeEnd);
    //fetch entries with Todo type from db by specified time range
    void fetchTodosByRange(QList<QVariantMap>* mapList, QDateTime rangeBegin, QDateTime rangeEnd);

private:
    //getList() match pattern
    QMap<QString,QVariant> m_matchCriteria;
    //transaction id
    qint32 m_trId;
    //CMulticalendar instance
    CMulticalendar* multiCalendar;
    //CCalendar instance
    CCalendar * calendar;
};
#endif // QGETLISTTASK_H
