/*
* ============================================================================
*  Name        : qcalendarconstants.h
*  Part of     : serviceframework / WRT
*  Description : constants collection for calendar service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef QCALENDARCONSTANTS_H_
#define QCALENDARCONSTANTS_H_

#include <QString>
#include <QDateTime>
#include <libical/ical.h>
#include <calendar-backend/CalendarErrors.h>
#include <calendar-backend/CAlarm.h>
#include <calendar-backend/CEvent.h>
#include <calendar-backend/CTodo.h>
#include <calendar-backend/CRecurrence.h>
#include <calendar-backend/CRecurrenceRule.h>



//Keys for Error Map
const QString KErrCode = "errorCode";
const QString KErrMessage = "errorMessage";
const int KInvalidTransId = -1;

//Key for transactionId
const QString KTransId = "transactionId";

//Key for Uid param
const QString KUid = "uid";

//key for id param
const QString KId = "id";

//keys for changeType param
const QString KChangeType = "changeType";
const QString KChangeTypeAdd = "Add";
const QString KChangeTypeModify = "Modify";
const QString KChangeTypeDelete = "Delete";

const QString KUndefined = "undefined";
const QString KFilled = "filled";
const QString KSeparator = ",";

//For Incedence custom type storage (like Reminder, Meeting, etc.)
const QByteArray KCustomTypeField("ctype");
const QByteArray KCustomTypeApp("capp");

//ical date limit
const QDateTime MAX_DATE_TIME(QDate(2037, 12, 31)); // Maximum date = 31-Dec-2037
const QDateTime MIN_DATE_TIME(QDate(1970, 01, 01)); // Minimum date = 01-Jan-1970
const QString MAX_DATE_TIME_AS_STRING("20371230T210000");

const int FEBRUARY = 2; //month number of February
const int MIN_DAYS_IN_FEBRUARY = 28; //number of days in February in no-leap year
const int MAX_DAYS_IN_MONTH = 31; //max day number in month
const int LAST_DAY_IN_MONTH = -1; //KCal repeat rule "last day of any month" value

//Data structures field names
const QString KTimeDataStart = "begin";
const QString KTimeDataEnd = "end";
const QString KTimeDataAlarm = "alarm";
const QString KTimeDataAlartmType = "alarmType";

const QString KRangeDataBegin = "begin";
const QString KRangeDataEnd = "end";

const QString KRepeatRuleFrequency = "frequency";
const QString KRepeatRuleStartDate = "startDate";
const QString KRepeatRuleUntilDate = "untilDate";
const QString KRepeatRuleInterval = "interval";
const QString KRepeatRuleWeekDays = "weekDays";
const QString KRepeatRuleMonth = "month";
const QString KRepeatRuleDaysOfMonth = "daysOfMonth";
const QString KRepeatRuleMonthDates = "monthDates";
//for CEvent database rType Field
const QString KRepeatRuleType = "repeatType";

const QString KCalendarEntryId = "id";
const QString KCalendarEntryType = "type";
const QString KCalendarEntryTime = "time";
const QString KCalendarEntrySummary = "summary";
const QString KCalendarEntryRepeatRule = "repeatRule";
const QString KCalendarEntryInstanceStartTime = "instanceStartTime";
const QString KCalendarEntryDescription = "description";
const QString KCalendarEntryStatus = "status";
const QString KCalendarEntryExceptionDates = "exceptionDates";
const QString KCalendarEntryLocation = "location";
const QString KCalendarEntryPriority = "priority";

const QString KMatchPatternId = "id";
const QString KMatchPatternRange = "range";
const QString KMatchPatternType = "type";
const QString KMatchPatternText = "text";

const QString KDeleteDataId = "id";
const QString KDeleteDataRange = "range";

//=============================================
//needed types:
const QString KTypeAnniversary = "Anniversary";
const QString KTypeDayEvent = "DayEvent";
const QString KTypeMeeting = "Meeting";
const QString KTypeReminder = "Reminder";
const QString KTypeToDo = "ToDo";
//existing types:
const int KTypeEvent = 1;
const int KTypeTodo = 2;
//=============================================

const QString KStatusTentative = "Tentative";
const QString KStatusConfirmed = "Confirmed";
const QString KStatusCancelled = "Cancelled";
const QString KStatusNeedsAction = "NeedsAction";
const QString KStatusCompleted = "Completed";
const QString KStatusUndefined = "Undefined";

const QString KFrequencyDaily = "daily";
const QString KFrequencyWeekly = "weekly";
const QString KFrequencyMonthly = "monthly";
const QString KFrequencyYearly = "yearly";

const QString KDayOfMonthDay = "day";
const QString KDayOfMonthWeekInMonth = "weekInMonth";

const QString KAlarmTypeOff = "off";
const QString KAlarmTypeSilent = "silent";
const QString KAlarmTypeWithTone = "with tone";
const QString KAlarmTypeOn = "on";

#endif /* QCALENDARCONSTANTS_H_ */
