# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
QT -= gui
QT += testlib sql
TEMPLATE = app
TARGET = wrtserviceresolvermoduletest
INCLUDEPATH += .. ../../inc ../../serviceresolution

ROOT_DIR = $$PWD/../../../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)

LIBS +=  -lwrtserviceipcserver -lwrtserviceipcclient -lwrtserviceresolution -lsecmgr -lwrtsecurestorage

SOURCES += serviceresolvermoduletest.cpp

EXPORT_FILES = ../../test/testdata/ServiceTest7.xml \
               ../../test/testdata/Test13.xml  

INCLUDEPATH += $$CWRT_INCLUDE \
               $$CWRT_HOME/tests/helpers/

symbian {
    TARGET.VID = 0x101FB657
    TARGET.CAPABILITY = ALL -TCB
    INCLUDEPATH += $$APP_LAYER_SYSTEMINCLUDE 
    
    EXPORT_DIR = "\\epoc32\\winscw\\c\\testdata\\"
    EXPORT_FILES += ..\..\test\testdata\s60\ServiceTest5.xml \
                    ..\..\test\testdata\s60\ServiceTest6.xml \
                    ..\..\test\testdata\testservice6.dll \
                    ..\..\test\testdata\testservice5.dll  
                    
    BLD_INF_RULES.prj_exports += "..\\..\\test\\testdata\\s60\\testservice.qtplugin \\epoc32\\winscw\\c\\resource\\qt\\sfwplugin\\testservice5.qtplugin"
    BLD_INF_RULES.prj_exports += "..\\..\\test\\testdata\\s60\\testservice.qtplugin \\epoc32\\winscw\\c\\resource\\qt\\sfwplugin\\testservice6.qtplugin"
       
    testdata.sources = ../../test/testdata/ServiceTest7.xml \
                       ../../test/testdata/Test13.xml \
                       ..\..\test\testdata\s60\ServiceTest5.xml \
                       ..\..\test\testdata\s60\ServiceTest6.xml
    testdata.path = /testdata
    testdata.pkg_postrules = \
        "\"$(CWRTPATH)\wrt\servicefw\test\testdata\s60\testservice5.dll\"    - \"c:\testdata\testservice5.dll\"" \
        "\"$(CWRTPATH)\wrt\servicefw\test\testdata\s60\testservice6.dll\"    - \"c:\testdata\testservice6.dll\"" \
        "\"$(CWRTPATH)\wrt\servicefw\test\testdata\s60\testservice.qtplugin\"    - \"!:\resource\qt\sfwplugin\testservice5.qtplugin\"" \
        "\"$(CWRTPATH)\wrt\servicefw\test\testdata\s60\testservice.qtplugin\"    - \"!:\resource\qt\sfwplugin\testservice6.qtplugin\""

    testdatadll.sources = ..\..\test\testdata\s60\testservice6.dll \     
                          ..\..\test\testdata\s60\testservice5.dll         
    testdatadll.path = /sys/bin
    
    DEPLOYMENT += testdata testdatadll     
}
else {
    QT += network 
    EXPORT_DIR = $$DESTDIR/testdata/
    EXPORT_FILES += ../../test/testdata/ServiceTest5.xml \
                    ../../test/testdata/ServiceTest6.xml 
    EXPORT_FILE_EXT = xml
    
    # Export dll files
    EXPORT_DLL_FILES = ../../test/testdata/testservice6.dll \
                       ../../test/testdata/testservice5.dll 
    win32 : EXPORT_DIR = $$replace(EXPORT_DIR, "\/", "\\")
                       
    export_dll_cmd.input = EXPORT_DLL_FILES
    export_dll_cmd.output = $$EXPORT_DIR${QMAKE_FILE_BASE}.dll
    export_dll_cmd.commands = $(COPY) ${QMAKE_FILE_NAME} $$EXPORT_DIR${QMAKE_FILE_BASE}.dll
    export_dll_cmd.CONFIG = target_predeps no_link
    export_dll_cmd.clean = $$EXPORT_DIR${QMAKE_FILE_BASE}.dll
    QMAKE_EXTRA_COMPILERS += export_dll_cmd
}
include($$WRT_DIR/cwrt-export.pri)

