/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceinfo_h
#define serviceinfo_h

#include <QStringList>

#if defined(QT_SERVICERESOLUTION_PRO)
#define SERVICEINFO_API Q_DECL_EXPORT
#else
#define SERVICEINFO_API Q_DECL_IMPORT
#endif

namespace WRT {

    class SERVICEINFO_API ServiceInfo
    {
    public:

        ServiceInfo();

        ServiceInfo(const QString& aName,const QString& aDllFileName, const QString& aServiceVersion,
                    const QString& aInterfaceVersion, const QString& aXmlFileName);

        ~ServiceInfo(void);

        QString serviceName();

        QString xmlFileName();

        QString serviceDllFileName();

        QString interfaceVersion();

        QString serviceVersion();

        QStringList interfaceCapabilities();

        void setServiceName(const QString& aName);

        void setServiceVersion(const QString& aVersion);

        void setXmlFileName(const QString& aXmlFileName);

        void setServiceDllFileName(const QString& aFileName);

        void setInterfaceVersion(const QString& aVersion);

        void setInterfaceCapabilities(const QString& interfaceCapabilities);

        QByteArray serialize();

        bool deserialize(const QByteArray& aDataStream);

        bool isValid();

    private:
        QString m_serviceXMLFileName;
        QString m_serviceName;
        QString m_serviceDllFileName;
        QString m_interfaceVersion;
        QString m_serviceVersion;
        QString m_interfaceCapabilities;
    };

}
#endif //serviceinfo_h
