/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef sfwservice_h
#define sfwservice_h

#include <QString>
#include <QList>
#include "servicemetadata_global.h"
#include "sfwinterface.h"

namespace WRT {

    class METADATA_EXPORT SFWService
    {
    public:

        SFWService();

        virtual ~SFWService();

        QString name();

        QString description();

        QString version();

        QString filePath();

        QString xmlFileName();

        int interfaceCount();

        void setName(const QString& aName);

        void setVersion(const QString& aVersion);

        void setDescription(const QString& aDescription);

        void setFilePath(const QString& aFilePath);

        void setXMLFileName(const QString& xmlFileName);

        void addInterface(SFWInterface* aInterface);

        SFWInterface* getInterface(int aIndex);

        void clear();

    private:
        QString m_name;
        QString m_version;
        QString m_description;
        QString m_filepath;
        QString m_xmlFileName;
        QList<SFWInterface*> m_interfaces;
    };

}

#endif /*sfwservice_h*/
