/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef servicemetadata_h
#define servicemetadata_h

#include <QXmlStreamReader>
#include <QStringList>
#include <QList>
#include <errdefs.h>
#include "servicemetadata_global.h"
#include "sfwservice.h"

namespace WRT {
    class METADATA_EXPORT ServiceMetaData
    {
    public:

        //! ServiceMetaData::ServiceMetadataErr
        /*!
         This enum describes the errors that may be returned by the Service metadata parser.
         */
        enum ServiceMetadataErr {
            SFW_ERROR_NO_SERVICE = METADATA_ERR_START_VALUE,    /*!< Can not find service root node in XML file*/
            SFW_ERROR_NO_SERVICE_NAME,                          /*!< Error no service name in XML file */
            SFW_ERROR_NO_SERVICE_VERSION,                       /*!< Error no service version in XML file */
            SFW_ERROR_NO_SERVICE_FILEPATH,                      /*!< Error no service filepath in XML file */
            SFW_ERROR_NO_SERVICE_INTERFACE,                     /*!< No interface for the service in XML file*/
            SFW_ERROR_NO_INTERFACE_NAME,                        /*!< Error no interface name in XML file*/
            SFW_ERROR_NO_INTERFACE_VERSION,                     /*!< Error no interface version in XML file*/
            SFW_ERROR_UNABLE_TO_OPEN_FILE,                      /*!< Error opening XML file*/
            SFW_ERROR_INVALID_XML_FILE,                         /*!< Not a valid XML file*/
            SFW_ERROR_PARSE_SERVICE,                            /*!< Error parsing service node */
            SFW_ERROR_PARSE_INTERFACE                           /*!< Error parsing interface node */
        };

    public:

        ServiceMetaData(const QString &aXmlFilePath);

        ~ServiceMetaData();

        void setXMLFilePath(const QString &aXmlFilePath);

        QString getXMLFileName();

        int getLatestError();

        bool extractMetadata();

        SFWService* getServiceMetadata();

    private:

        bool processServiceElement(QXmlStreamReader &aXMLReader);

        bool processInterfaceElement(QXmlStreamReader &aXMLReader);

    private:
        QString m_xmlFilePath;
        QString m_xmlFileName;
        SFWService* m_serviceInfo;
        int m_latestError;
    };

}

#endif // servicemetadata_h
