# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
TEMPLATE = lib
TARGET = WrtServiceHandler
QT -= gui
CONFIG += link_prl create_prl
LIBS += -lWrtServiceIpcClient -lWrtServiceResolution -lWrtSecurityManager

ROOT_DIR = $$PWD/../../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)
INCLUDEPATH += . ../inc ../serviceresolution ../serviceresolver 

# Input
HEADERS += servicehandler.h servicehandler_p.h
SOURCES += servicehandler.cpp servicehandler_p.cpp


DEFINES += QT_MAKE_DLL

INCLUDEPATH += $$CWRT_INCLUDE

    QT +=network
    # Export headers
    EXPORT_DIR = $$CWRT_INCLUDE
    EXPORT_FILES = ./servicehandler.h \
        ../inc/errdefs.h \
        ../inc/iterable.h \
        ../inc/service.h \
        ../inc/servicebase.h \
        ../inc/servicedebug.h \
        ../inc/serviceframeworkdefs.h \
        ../inc/serviceinterfaceinfo.h \
        ../inc/serviceplugininterface.h \
        ../inc/servicesecurityinterface.h \
        ../inc/sfwerrorhandler.h \
        ../inc/sfwexception.h \
        ../inc/sfwlog.h \
        ../inc/sfwservicelogger.h 

include($$WRT_DIR/cwrt-export.pri)

unix:!symbian {
    headers.files = $PWD/servicehandler.h
    headers.path = $$CWRT_INSTALL_INC_DIR/wrt/servicefw/servicehandler

    headers_inc.files = \
        $$PWD/errdefs.h \
        $$PWD/iterable.h \
        $$PWD/service.h \
        $$PWD/servicebase.h \
        $$PWD/serviceinterfaceinfo.h \
        $$PWD/serviceplugininterface.h \
        $$PWD/servicesecurityinterface.h \
        $$PWD/sfwerrorhandler.h \
        $$PWD/sfwexception.h \
        $$PWD/sfwlog.h \
        $$PWD/sfwservicelogger.h
    headers_inc.path = $$CWRT_INSTALL_INC_DIR/wrt/servicefw

    INSTALLS += headers headers_inc
}
