/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef servicehandler_h
#define servicehandler_h

#include <QString>
#include <QObject>
#include <QList>
#include <QStringList>
#ifdef __SYMBIAN32__
#include <e32base.h>
#endif // __SYMBIAN32__

#include "servicebase.h"
#include "sfwerrorhandler.h"

/**
 * Class export macro
 */
#if defined(QT_MAKE_DLL)
#define SERVICE_API Q_DECL_EXPORT
#else
#define SERVICE_API Q_DECL_IMPORT
#endif

// FORWARD DECLARATION
class QPluginLoader;
class QLocalSocket;

namespace WRT {

    class ServiceFwIPC;
    class SecSession;
    class ServiceHandlerPrivate;

    class SERVICE_API ServiceHandler : public QObject, public SFWErrorHandler
    {
    Q_OBJECT

        // Constructor and Destructor
    public:

        ServiceHandler(QObject* parent);
        ~ServiceHandler();
        // Public methods
    public:
        /*!
         Creates an instance of a service and return interface pointer

         @param aServiceName Name of the service provider
         @param aInterfaceInfo Interface info
         @param aSecSession Security Session (not owned). If NULL then that means
                            no security check will be done.
         @param aParent QObject parent for the client instance
         @param aRefCounted true the underlying service object is reference counted.
                            false  the underlying service object is not reference counted
                                   and the object is owned by service handler
         @return IServiceBase* interface pointer to the service if the service is found,
                               NULL if service is not found
         */
        template<class T>
        void getInterface(T** aInterface,
                          const QString &aServiceName,
                          const ServiceInterfaceInfo& aInterfaceInfo,
                          bool aRefCounted,
                          SecSession *aSecSession)
        {
            Q_ASSERT(aInterface);
            ServiceInterfaceInfo tempInterfaceInfo = aInterfaceInfo;
            IServiceBase* base = getServiceBase(aServiceName, tempInterfaceInfo, aRefCounted, aSecSession);
            if (base) {
                base->getInterface(tempInterfaceInfo, aInterface);
            } else {
                *aInterface = NULL;
            }
        }

        QStringList getServiceProviders(SecSession *aSecSession = NULL);

        QString getServiceVersion(const QString &aServiceName);

    protected:
        friend class ServiceHandlerPrivate;
        ServiceHandlerPrivate* d;

    private:
        IServiceBase* getServiceBase(const QString &aServiceName,
                                     ServiceInterfaceInfo& aInterfaceInfo,
                                     bool aRefCounted,
                                     SecSession *aSecSession);
    };
}
#endif // servicehandler_h
