/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef npdef_h
#define npdef_h

#if defined(__GNUC__)
    #define ATTRIBUTE_USED __attribute__((used))
#else
    #define ATTRIBUTE_USED
#endif // __GNUC__

#ifdef __SYMBIAN32__
    #include <QEvent>
    #include <QRegion>
    #include <badesca.h>
    #include <e32base.h>
    #include <bldvariant.hrh>
    #undef _WINDOWS
    #if defined(__S60_50__)
        #ifdef __WINSCW__
            #undef _WIN32
        #endif //__WINSCW__
        #ifdef CWRT_BUILDING_NINETWO
        // there is bug is ninetwo qmake, which always finds headers from
        // /epoc32/include/mw
            #include "../../3rdparty/npapi/npapi.h"
        #else
            #include <npapi.h>
        #endif
        #ifdef __WINSCW__
            #define _WIN32
        #endif //__WINSCW__
        #if !defined(CWRT_S60_WEBKIT)
            namespace AVKONNP {
            #include <npscript.h>
            }
            using namespace AVKONNP;
            #include <npupp.h>
        #else // CWRT_S60_WEBKIT defined
            #include <npfunctions.h>
        #endif // CWRT_S60_WEBKIT
    #else // not _S60_50__; S60 v3.1, v3.2
        #if !defined(CWRT_S60_WEBKIT)
            #include <npupp.h>
            #include <javascriptcore/npruntime.h>
        #else // CWRT_S60_WEBKIT defined
            #ifdef __WINSCW__
                #undef _WIN32
            #endif //__WINSCW__
            #include <npapi.h>
            #ifdef __WINSCW__
                #define _WIN32
            #endif //__WINSCW__
            #include <npruntime.h>
            #include <npfunctions.h>
        #endif // CWRT_S60_WEBKIT
    #endif // __S60_50__
#else // not __SYMBIAN32__
    #include <npapi.h>
    #include <npruntime.h>
    #include <npfunctions.h>
#endif //  __SYMBIAN32__

#endif //npdef_h






