/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef bindingdef_h
#define bindingdef_h

#include "npdef.h"

class SecSession;

/**
 * Class export macro
 */
#if defined (Q_OS_SYMBIAN) || defined (Q_OS_WIN32)
#ifdef QT_MAKE_JSBINDING_DLL
#define BINDING_API __declspec(dllexport)
#else
#define BINDING_API __declspec(dllimport)
#endif // QT_MAKE_JSBINDING_DLL
#else //defined __linux__
#define BINDING_API
#endif

#ifdef __cplusplus
extern "C" {
#endif

BINDING_API void bindingInitialize(NPNetscapeFuncs* npnFuncs);
BINDING_API NPObject* createFactoryObject(NPP npp);

#ifdef __cplusplus
}
#endif

#endif //bindingdef_h
