/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_USERCONDITIONHANDLER_H
#define __WRT_USERCONDITIONHANDLER_H

#include "capability.h"
#include "usercondition.h"

namespace WRT {

    /**
    * \class UserConditionHandler
    * Interface class for handling conditions. For example the client
    * that implements this can prompt the user to ask for permission
    * to grant capabilites.
    */
    class UserConditionHandler {
    public:
        virtual ~UserConditionHandler(){}
        /**
        * Asks the handler whether or not the capability can be allowed
        * \param[in] capabilities - Capabilities requested
        * \param[in] conditions - The conditions for these capabilities
        * \param[in,out] grant - The current grant flag.  This method must modify the grant
        *                         flag if needed.
        * \return TRUE if allowed, else FALSE
        */
        virtual bool allow(const QString &serviceName,
                           const CapabilityList &capabilities,
                           unsigned int conditions,
                           unsigned int &grant) const = 0;
    };

}
#endif  //__WRT_USERCONDITIONHANDLER_H
