/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_TRUSTPARSER_H
#define __WRT_TRUSTPARSER_H

#include <QHash>
#include <QStringList>
#include "secmgrdefs.h"


// FORWARD DECLARATIONS
class QXmlStreamReader;

namespace WRT {

    // FORWARD DECLARATIONS

    class TrustParser: public QObject
    {
        Q_OBJECT
    public:
        TrustParser();
        TrustParser(const QString &policy);
        TrustParser(const QByteArray &policy);
        ~TrustParser();

        //===========================================================
        // Own interface methods
        //===========================================================
        void cleanup();
        void setPolicy(const QString &policy);
        void setPolicy(const QByteArray &policy);
        bool parse();
        const QString defaultDomain() const;
        const QString defaultOriginDomain() const;
        const QString defaultAppPathDomain() const;
        const QString domainFor(TrustCriteriaType type,
                                const QString &value) const;
        QStringList values(TrustCriteriaType type) const;

    private:
        void createDomainList();
        const QHash<QString,QString> *getHashList(const TrustCriteriaType type) const;
        bool processDefaultDomain();
        bool processDomain();

    private:
        QXmlStreamReader *m_xmlReader;
        QList<QHash<QString,QString> > m_domainList;
        QString m_defaultDomain; // the default of default
        QHash<TrustCriteriaType,QString> m_defaultDomainHash;
    };

}
#endif  // __WRT_TRUSTPARSER_H
