/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_SECSESSION_P_H
#define __WRT_SECSESSION_P_H

//  INCLUDES
#include <QObject>
#include <QString>
#include <QHash>
#include "capability.h"

namespace WRT {

  // FORWARD DECLARATIONS
  class SecPolicy;
  class UserConditionHandler;

  // CLASS DECLARATION
  class SecSessionPrivate
  {
  public:
    SecSessionPrivate(const QByteArray &policy,
              const QString &domain,
              const QString &store);
    SecSessionPrivate(const QString &key,
              const QString &store,
              UserConditionHandler *handler = NULL);
    SecSessionPrivate(const QByteArray &blob,
                      UserConditionHandler *handler = NULL);
    SecSessionPrivate(const QString &policyFileName,
           const QString &trustDomain,
           const QString &secureStoreLocation,
           UserConditionHandler *handler);
    ~SecSessionPrivate();

    const SecPolicy *m_policy;
    QString m_domain;
    QString m_store;
    const CapabilitySet *m_allowedCaps;
    QString m_key;
    QHash<QString, QString> m_clientInfo;
  };

}
#endif  // __WRT_SECSESSION_H
