/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_SECSESSION_H
#define __WRT_SECSESSION_H

//  INCLUDES
#include <QObject>
#include <QString>
#include <QByteArray>
#include <QHash>
#include "capability.h"

/**
* Class export macro
*/
#if defined(QT_MAKE_SECURITY_DLL)
#define SECURITY_API Q_DECL_EXPORT
#else
#define SECURITY_API Q_DECL_IMPORT
#endif

// FUNCTION PROTOTYPES


// CLASS DECLARATION
namespace WRT {

  // FORWARD DECLARATIONS
  class UserConditionHandler;
  class SecSessionPrivate;

  class SECURITY_API SecSession : public QObject
  {
    Q_OBJECT
      friend class SecSessionPrivate;

  public:
    SecSession(const QByteArray &policy,
           const QString &domain,
           const QString &store);
    SecSession(const QString &key,
               const QString &store,
               UserConditionHandler *handler = NULL);
    SecSession(const QByteArray &blob,
               UserConditionHandler *handler = NULL);
    SecSession(const QString &policyFileName,
           const QString &trustDomain,
           const QString &secureStoreLocation,
           UserConditionHandler *handler = NULL);
    ~SecSession();
    bool isAllowed(const CapabilityList &neededCaps);
    bool persist();
    bool persist(QByteArray &blob);
    bool saveSecsession(QString resourcesDir, QString secureSessionString);
    void setUserHandler(UserConditionHandler *handler) const; //TBD: Should be non const
    QString key() const;
    void setDisplayText(const QString &text);
    QString displayText() const;
    void setClientName(const QString &clientName);
    QString clientName() const;
    const QHash<QString, QString> &clientInfo() const;
    void setClientInfo(const QString &key, const QString &value);

  private:
    bool atLeastOneAllowed(const CapabilityList &needed);
    SecSessionPrivate *m_privSecSession;
  };

}
#endif  // __WRT_SECSESSION_H
