/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#include "certificatehandler.h"
#include "trustparser.h"

//TBD: replace this with WebKit same-origin check

namespace WRT
{

/*!
 * \class CertificateHandler
 * Implementation class of TrustPropHandler interface.
 * This class uses the certificate DN to find corresponding domain
 */

/*!
 * Constructor
 * \pre Must have already parsed the policy file.
 */
CertificateHandler::CertificateHandler()
{
    m_parser = NULL;
}

/*!
 * Gets the domain for a specified value
 * \param[in] value - Value to get the domain for
 * \return The requested domain
 */
QString CertificateHandler::domainFor(const QString &value)
{
    QString result;
    if (m_parser) {
        result = m_parser->domainFor(ETrustCriteriaCertificate, value);
    }
    return result;
}

} // end namespace WRT
