/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef sslog_h
#define sslog_h

#ifdef _DEBUG
#include <QString>
#include <QByteArray>
#include <QDebug>

#ifdef __SYMBIAN32__

#define SS_DEBUG(s)             qDebug() << s;
#define SS_FUNC(fn)             FunctionTrace _s(fn);

#else

#define SS_DEBUG(s);//             qDebug() << s;
#define SS_FUNC(fn);//             FunctionTrace _s(fn);

#endif
// output debug messages to a log file as well as debug console if in Symbian
// in other platforms, only output to debug console
#ifdef __SYMBIAN32__

#include <e32cmn.h>
#include <e32def.h>

#define KUSELOGFILE 0

// folder name relative to c:\logs\, must be created manually
_LIT(KSSLogDir, "ss");
// name of the log file
_LIT(KSSLogFile, "ss_log.txt");
#endif //__SYMBIAN32__


class FunctionTrace
{
public:
    explicit FunctionTrace(const char* aName, void* aThis=NULL):iStr(aName), iThis(aThis)
    {
        if (iThis)
        {
            // TODO:
            qDebug() << "-->" << iStr;
        }
        else
        {
            qDebug() << "-->" << iStr;
        }
    }
    ~FunctionTrace()
    {
        if (iThis)
        {
            // TODO
            qDebug() << "<--" << iStr;
        }
        else
        {
            qDebug() << "<--" << iStr;
        }
    }
private:
    QString iStr;
    void *iThis;
};

#else
#define SS_DEBUG(s)
#define SS_FUNC(fn)
#endif //_DEBUG

#endif //sslog_h
