/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include <QIODevice>
#include <QDataStream>
#include "securestoragemetadata.h"

namespace WRT
{
/*!
 * \class WRT::SecureStorageMetadata
 * Implementation of secure storage metadata on Symbian systems
 */

/*!
 * Constructor
 * \param[in] aParent - QObject parent
 */
SecureStorageMetadata::SecureStorageMetadata(QObject *aParent /*=NULL*/) :
    QObject(aParent)
{
}

/*!
 * Destructor
 */
SecureStorageMetadata::~SecureStorageMetadata()
{
}

void SecureStorageMetadata::setSourceFile(const QString &aSourceFile)
{
    m_sourceFile = aSourceFile.toLower();
}

const QString SecureStorageMetadata::sourceFile() const
{
    return m_sourceFile;
}

void SecureStorageMetadata::setHash(const QByteArray &aHash)
{
    m_hash = aHash;
}

const QByteArray SecureStorageMetadata::hash() const
{
    return m_hash;
}

bool SecureStorageMetadata::internalize(QIODevice &aDevice)
{
    bool result(false);
    if (aDevice.open(QIODevice::ReadOnly)) {
        QDataStream in(&aDevice);
        in >> m_sourceFile;
        m_sourceFile = m_sourceFile.toLower();
        in >> m_hash;
        aDevice.close();
        result = true;
    }
    return result;
}

bool SecureStorageMetadata::externalize(QIODevice &aDevice) const
{
    bool result(false);
    if (aDevice.open(QIODevice::WriteOnly)) {
        QDataStream out(&aDevice);
        out << m_sourceFile;
        out << m_hash;
        aDevice.close();
        result = true;
    }
    return result;
}

} // end namespace WRT
