/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WRT_SECURESTORAGE_H
#define __WRT_SECURESTORAGE_H

//  INCLUDES
#include <QProcess>
#include <QHash>
#include <QByteArray>
#include "storage.h"

/**
* Class export macro
*/
#if defined(QT_MAKE_SECURESTORAGE_DLL)
#define SECURESTORAGE_API Q_DECL_EXPORT
#else
#define SECURESTORAGE_API Q_DECL_IMPORT
#endif


namespace WRT {
    // Forward Declarations
    class SecureStorageMetadata;

    class SECURESTORAGE_API SecureStorage: public Storage {
        Q_OBJECT

    public:
        SecureStorage(const QString &aStorageName,
                      Storage::visibility aVisibility = vis_shared,
                      Storage::protection aProtection = prot_signed,
                      QObject* aParent = 0);
        virtual ~SecureStorage();
        virtual QStringList getFileList() const;
        virtual void add(const QFile & aFile);
        virtual void add(const QString & aFilePath, const QBuffer & aData);
        virtual void remove(const QFile & aFile);
        virtual bool verify(const QFile & aFile) const;
        virtual QIODevice * getFile(const QString & aPathFile);
        virtual qint32 count() const;
        //virtual QString storageName() const;  // Implemented by Storage base class

    protected:  // methods
        virtual QByteArray createHash(const QByteArray &aData) const;
        virtual QHash<QString, QString> updateFileList() const;
        virtual void updateMetadataInfo(const QString &aFileName,
                                        const QByteArray &aData);
        virtual void saveFileList() = 0;
        virtual QByteArray encryptData(const QByteArray &aData) = 0;
        virtual QIODevice *decryptData(const QByteArray &aData) = 0;
        virtual void saveMetadata(const SecureStorageMetadata &aMetadata) = 0;
        virtual void removeMetadata(const QString &aFileName) = 0;
        virtual SecureStorageMetadata *getMetadata(const QString &aFileName) const = 0;
        virtual QString getOwner() const = 0;

    protected:  // members
        // QString m_storageName;   // Defined in Storage base class
        Storage::visibility m_visibility;
        Storage::protection m_protection;
        QHash<QString, QString> m_fileList;
        QString m_currentFile;
    };
}

#endif  // __WRT_SECURESTORAGE_H
