/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTCONTROLLER_H__
#define __WRTCONTROLLER_H__

#include <QObject>
#include <QAction>
#include <QWidget>
#include "wrtglobal.h"
#include "runtimeglobal.h"
#ifdef CWRT_BUILDING_TENONE
#include "hbwidget.h"
#endif

class QGraphicsWebView;

namespace WRT {

class WrtPage;
class WrtControllerPrivate;

class RUNTIME_EXPORT WrtController : public QObject
{
    Q_OBJECT
public:
#ifdef CWRT_BUILDING_TENONE
    WrtController(HbWidget* parent, WebKitView webkitView = WRT::WebView);
#else
    WrtController(QWidget* parent, WebKitView webkitView = WRT::WebView);
#endif
    WrtController(QWidget* parent, WrtPage* wrtPage, WebKitView webkitView = WRT::WebView);
    virtual ~WrtController();

    WrtPage* wrtPage();
    QWidget* webWidget();
    QGraphicsWebView* graphicsWebView();

#ifdef CWRT_BUILDING_TENONE
signals:
    void pauseNavigation();
    void resumeNavigation();
#endif

public slots:
    void enableContextMenu(bool enable);

private:
    WrtControllerPrivate* d;

};

}
#endif
