/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WEBNAVIGATION_H
#define WEBNAVIGATION_H
#include "runtimeglobal.h"
#include <QObject>

class QWebPage;

namespace WRT {

    class WebTouchNavigation;
    class WebCursorNavigation;
    class WebDirectionalNavigation;
    class WebHtmlTabIndexedNavigation;

    class WebNavigation : public QObject
    {
    Q_OBJECT
    public:
        WebNavigation(QObject *object, QWebPage* webPage);
        virtual ~WebNavigation();

    public slots:
        void setNavigationMode();
#ifdef CWRT_BUILDING_TENONE
        void pauseNavigation();
        void resumeNavigation();
#endif

    private:
        QObject* m_viewObject;
        QWebPage* m_webPage;
        WebTouchNavigation* m_webTouchNavigation;
        WebCursorNavigation* m_webCursorNavigation;
        WebDirectionalNavigation* m_webDirectionalNavigation;
        WebHtmlTabIndexedNavigation* m_webHtmlTabIndexNavigation;

    };

}

#endif
