/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WEBDIRECTIONALNAVIGATION_H
#define WEBDIRECTIONALNAVIGATION_H

#include <QObject>
#include <QEvent>
#include <QKeyEvent>
#include <QTimer>
#include <QPixmap>
#include <QVector>
#include <qwebelement.h>

class QWebPage;

namespace WRT {

    class WebDirectionalNavigation : public QObject
    {
    Q_OBJECT
    public:
        WebDirectionalNavigation(QObject* object, QWebPage* webPage);
        virtual ~WebDirectionalNavigation();

    protected:
        bool eventFilter(QObject *object, QEvent *event);
        void initiallayoutCompleted();
        double calculateElementDistance(int direction, const QRect& possibleRect);
        bool nextElementInDirection(int direction);
        void scrollFrame(int direction);
        void scrollFrameOneDirection (int direction, int distance);

    protected:
        QObject* m_viewObject;
        QWebPage* m_webPage;
        QWebElement m_webElement;
        QPoint m_focusPoint;
        QString m_selectedElementStyle;
    };

}

#endif
