if (typeof ovi == 'undefined') {
    ovi = {};
}
if (typeof ovi.service == 'undefined') {
    // define ovi.service namespace if not defined yet
    ovi.service = {};
}

ovi.service.SUCCESS = 0;

/**
 * Error code range 1-49
 * Generic non-recoverable errors
 */
ovi.service.MISSING_ARG_ERR = 1;
ovi.service.INVALID_ARG_ERR = 2;
ovi.service.NOT_SUPPORTED_ERR = 3;
 
/**
 * Error code range 100-499
 * Generic recoverable errors
 */
ovi.service.TIMEOUT_ERR = 100;
ovi.service.DATA_NOT_FOUND_ERR = 101;
ovi.service.DATA_ALREADY_EXISTS_ERR = 102;
ovi.service.SERVICE_BUSY_ERR = 103;
ovi.service.SERVICE_IN_USE_ERR = 104;
ovi.service.DATA_OUT_OF_RANGE_ERR = 105;
ovi.service.NOT_ALLOWED_ERR = 106;
ovi.service.SIZE_EXCEEDED_ERR = 107;
ovi.service.INVALID_URI_ERR = 108;
ovi.service.URI_NOT_FOUND_ERR = 109;
ovi.service.URI_ALREADY_EXISTS_ERR = 110;
ovi.service.NO_MEMORY_ERR = 111;
ovi.service.STARTUP_ERR = 112;
ovi.service.GENERAL_ERR = 113;
ovi.service.CANCEL_ERR = 114;
ovi.service.NO_DISK_SPACE = 115;
ovi.service.PERMISSION_DENIED = 116;
ovi.service.CORRUPT_DATA = 117;

ovi.service.Exception = function(errorCode, errMessage, errType) {
    this.name = "Exception";
    this.code = errorCode;
    this.message = errMessage;
    this.type = errType;
}

ovi.service.Error = function(errorCode, errMessage) {
    this.code = errorCode;
    this.message = errMessage;
}
