#
# ============================================================================
#  Name        : serviceipcserver.pro
#  Part of     : Service Framework / IPC Server
#  Description : Service Framework IPC
#  Version     : %version: 17 %
#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
TEMPLATE = lib
TARGET = WrtServiceIpcServer
QT -= gui
CONFIG += link_prl create_prl

ROOT_DIR = $$PWD/../../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)

#Sources
HEADERS += serviceipcserverfactory.h \
           serviceipcserver.h \
           serviceipcserver_p.h \ 
           serviceipcobserver.h \
           serviceipcserversession.h \
           serviceipcrequest.h \
           sessionidtable.h

SOURCES += serviceipcserverfactory.cpp \
           serviceipcserver.cpp \
           serviceipcserversession.cpp \
           serviceipcrequest.cpp \
           sessionidtable.cpp
           
DEFINES += QT_MAKE_IPC_SERVER_DLL
INCLUDEPATH += $$CWRT_INCLUDE

EXPORT_FILES = serviceipcserver.h \
    serviceipcobserver.h \
    serviceipcserversession.h \
    serviceipcrequest.h \
    clientinfo.h

QT +=network
#Export directory
EXPORT_DIR = $$CWRT_INCLUDE
    
HEADERS += ./platform/qt/serviceipcserverlocalsocket_p.h \
           ./platform/qt/serviceipclocalsocketsession.h
SOURCES += ./platform/qt/serviceipcserverlocalsocket.cpp \
           ./platform/qt/serviceipclocalsocketsession.cpp
    
INCLUDEPATH += $$PWD/platform/qt

include($$WRT_DIR/cwrt-export.pri)

headers.files = $$EXPORT_FILES
headers.path = $$CWRT_INSTALL_INC_DIR/wrt/ipc/serviceipcserver

INSTALLS += headers
