/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceipcsharedmem_p_h
#define serviceipcsharedmem_p_h

#include <QtCore>
#include "serviceipc_p.h"

namespace WRT {

    class ServiceSharedMemIPC : public ServiceFwIPCPrivate
    {
    public:
        ServiceSharedMemIPC();

        virtual ~ServiceSharedMemIPC();

    public:

        bool connect(const QString& aServerName);

        void disconnect();

        bool startServer(const QString& aServerName, const QString& aExeName);

        bool sendSync(const QString& aRequestType, const QByteArray& aData);

        void sendAsync(const QString& aRequestType, const QByteArray& aData);

        QByteArray readAll();

        bool waitForRead();
    };

}
#endif // serviceipcsharedmem_p_h
