# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

####################################################################################
#
# cwrt-webkit.pri
#
# This project include file must be included by every app or wrt component
# that has dependencies on webkit.
#
# This include will detect the webkit version associated with the project.
# Per default, it selects the webkit that is embedded in the QT distribution.
# The default can be overridden by WEBKIT_DIR environment variable.
#
# cwrt-webkit.pri includes cwrt.pri.
# Thus, components that include(cwrt-webkit.pri) should not include(cwrt.pri) again. 
#
####################################################################################

isEmpty(_CWRT_WEBKIT_PRI_INCLUDED_): {

    # This flag, for preventing re-entry, only works within same pro-file context,
    # not across subdir invocations
    _CWRT_WEBKIT_PRI_INCLUDED_=1

    # Use default webkit (embedded in QT distribution) or alternative?
    WEBKIT_DIR = $$(WEBKIT_DIR) 
    isEmpty(WEBKIT_DIR) {
        QT += webkit
        WEBKIT_DIR = $$[QT_INSTALL_PREFIX]/src/3rdparty/webkit
        WEBKIT_LIB_DIR = $$[QT_INSTALL_PREFIX]/lib
	# npapi headers, make sure Qt webkit npapi is before symbian one
	# we need to use local copy of npapi because $QTDIR/src/3rdparty/webkit
	# does not exist on all platforms.
	INCLUDEPATHBACKUP = $$INCLUDEPATH
	INCLUDEPATH = $$PWD/3rdparty/npapi
	INCLUDEPATH += $$INCLUDEPATHBACKUP
	symbian: INCLUDEPATH += $$PWD/3rdparty/npapi/platform/symbian
    } else {
   
        CONFIG(release, debug|release) {
            WEBKIT_LIB_DIR = $$WEBKIT_DIR/WebKitBuild/Release/lib
        }
        
        CONFIG(debug, debug|release) {
            WEBKIT_LIB_DIR = $$WEBKIT_DIR/WebKitBuild/Debug/lib
        }
        
        LIBS += -lQtWebKit
	INCLUDEPATH += \
		$$WEBKIT_DIR/WebKit/qt/Api \
		$$WEBKIT_DIR/WebCore/bridge \
		$$WEBKIT_DIR/WebCore/plugins    
	symbian: INCLUDEPATH += $$WEBKIT_DIR/WebCore/plugins/symbian
    }

    include($$PWD/cwrt.pri)

    QMAKE_RPATHDIR = $$DESTDIR $$WEBKIT_LIB_DIR $$QMAKE_RPATHDIR
    QMAKE_LIBDIR   = $$DESTDIR $$WEBKIT_LIB_DIR $$QMAKE_LIBDIR
    
} # end _CWRT_WEBKIT_PRI_INCLUDED_
