


#include "zzip.h"
#include "unzip.h"
#include <QDebug>
#include <QDir>
#include <QFileInfo>
#include <QFile>

int Zzip::unzip(const QString &path, const QString &unZipPath, unsigned long &size)
{
    unzFile ufile = NULL;
    unz_global_info globalInfo;
    QDir destDir(unZipPath);

    ufile = unzOpen(path.toLocal8Bit().data());
    if (unzGetGlobalInfo(ufile, &globalInfo)) {
        qCritical() << "Failed to extract the widget: unable to get information of " << path;
        unzClose(ufile);
        return -1;
    }

    char fName[256];
    unz_file_info finfo;
    QString fileName, dirName;
    uLong uncompressed_size = 0;

    for (unsigned int i = 0; i < globalInfo.number_entry; ) {
        if (UNZ_OK != unzGetCurrentFileInfo(ufile, &finfo, fName, 256, NULL, 0, NULL, 0)) {
            qCritical() << "Failed to extract files from the widget: unable to get the information of the file for unzip";
            return -1;
        }

        fileName = destDir.absolutePath() + "/" + QString(fName);
        dirName = fileName.left(fileName.lastIndexOf('/'));
        if (!dirName.isEmpty() && !QFileInfo(dirName).exists()) {
            if (!destDir.mkpath(dirName)) {
                qCritical() << "Failed to extract files from the widget: unable to create directory " << dirName;
                return -1;
            }
        }

        if (QFileInfo(fileName).isDir()) {
            int result = unzGoToNextFile(ufile);

            if (UNZ_END_OF_LIST_OF_FILE == result)
                return 0;

            if (UNZ_OK != result) {
                qCritical() << "Failed to extract files from the widget: unable to get the information for the next file";
                return -1;
            }
            continue;
        }

        uncompressed_size += finfo.uncompressed_size;
        QByteArray content(finfo.uncompressed_size, 0);
        if (UNZ_OK != unzOpenCurrentFile(ufile)
            || 0 > unzReadCurrentFile(ufile, content.data(), content.size())
            || UNZ_OK != unzCloseCurrentFile(ufile)) {
            qCritical() << "Failed to extract files from the widget: unable to extract file from the widget";
            return -1;
        }

        QFile newFile(fileName);
        if (!newFile.open(QIODevice::WriteOnly)
            || -1 == newFile.write(content)) {
            qCritical() << "Failed to extract files from the widget: unable to write the extracted file to " << fileName;
            return -1;
        }

        newFile.close();

        if (++i < globalInfo.number_entry) {
            int result = unzGoToNextFile(ufile);

            if (UNZ_END_OF_LIST_OF_FILE == result)
                return 0;

            if (UNZ_OK != result) {
                qCritical() << "Failed to extract files from the widget: unable to switch to the next file";
                return -1;
            }
        }
    }

    size = uncompressed_size;

    unzClose(ufile);

    return 0;
}


unsigned long Zzip::uncompressedSize( const QString& path)
{
    unsigned long ret = 0;
    unzFile ufile = NULL;
    unz_global_info globalInfo;

    ufile = unzOpen(path.toLocal8Bit().data());
    if (unzGetGlobalInfo(ufile, &globalInfo)) {
        qWarning() << "Zzip::uncompressedSize(): unzGetGlobalInfo() failed";
        unzClose(ufile);
        return -1;
    }

    char fName[256] = {0};
    unz_file_info finfo;
    QString fileName;

    for (unsigned int i = 0; i < globalInfo.number_entry; ) {
        unzGetCurrentFileInfo(ufile, &finfo, fName, 256, NULL, 0, NULL, 0);

        if (QFileInfo(fileName).isDir()) {
            unzGoToNextFile(ufile);
            continue;
        }

        ret += finfo.uncompressed_size;

        if (++i < globalInfo.number_entry)
            unzGoToNextFile(ufile);
    }

    unzClose(ufile);
    return ret;
}
