/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "widgetinstallertesthelper.h"
#include "WidgetManager.h"
#include "WidgetProperties.h"
#include "WgtWidget.h"
#include "SuperWidget.h"

#include <QString>
#include <QFile>
#include <QTextStream>

namespace WRT {
namespace Maemo {

void WidgetInstallerTestHelper::writeOutput(WidgetManager & widgetManager) {
    QString installedWidget("/var/tmp/lastInstalledWidget");
    QFile fp(installedWidget);
    if (fp.open(QIODevice::ReadWrite | QIODevice::Truncate)) {
        SuperWidget * widget = widgetManager.m_installingWidget;
        WidgetProperties * props = 0;
        if (widget) {
            props = widget->getProperties(widget->widgetUnZipPath());
        }
        QTextStream str(&fp);
        if (props) {
            int appId = qHash(props->id());
            str << appId << "\n";
            str << appId << "-wrt-widget"  << "\n";
            str << props->installPath() << "\n";
        } else {
            str << "FAIL\n";
            str << "FAIL\n";
            str << "FAIL\n";
        }
    }
    fp.close();
}
}
}
