/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include <hildon/hildon-program.h>
#include <hildon/hildon-banner.h>

#include <gtk/gtk.h>
#include <libosso.h>
#include <unistd.h>

#define OSSO_WIDGETINSTALLER_NAME    "com.nokia.widgetinstaller"
#define OSSO_WIDGETINSTALLER_SERVICE "com.nokia."OSSO_WIDGETINSTALLER_NAME
#define OSSO_WIDGETINSTALLER_OBJECT  "/com/nokia/"OSSO_WIDGETINSTALLER_NAME
#define OSSO_WIDGETINSTALLER_IFACE   "com.nokia."OSSO_WIDGETINSTALLER_NAME

typedef struct _AppData AppData;

struct _AppData {
    HildonProgram *program;
    osso_context_t *osso_context;
};

gint dbus_handler(const gchar * interface, const gchar * method,
        GArray * arguments, gpointer data, osso_rpc_t * retval) {

    AppData *appdata;
    GPid pid;
    appdata = (AppData *) data;
    gchar *args[3];
    GSpawnFlags flags = G_SPAWN_STDOUT_TO_DEV_NULL;
    int i = arguments->len;

    if (!i)
        return -1;

    args[0] = "/usr/bin/widgetinstaller";
    args[2] = NULL;

    osso_rpc_t *t = &g_array_index(arguments, osso_rpc_t, 0);
    gchar *contents;

    // got string
    if (t->type != DBUS_TYPE_STRING) {
        return OSSO_ERROR;
    }

    // take the string part out of osso_rpc_t
    contents = t->value.s;

    gchar *contents_uri =  g_filename_from_uri(contents, NULL, NULL);

    // handles local files opened with web browser
    if (contents_uri == NULL)
        args[1] = contents;
    // handles local files opened with filemanager
    else
        args[1] = contents_uri;

    if (!g_spawn_async(NULL, args, NULL, flags, NULL, NULL, &pid, NULL)) {
        return OSSO_ERROR;
    }

    return OSSO_OK;
}

int main(int argc, char *argv[]) {

    HildonProgram *program;
    osso_context_t *osso_context;
    osso_return_t result;
    AppData *appdata;
    gtk_init(&argc, &argv);

    osso_context = osso_initialize(OSSO_WIDGETINSTALLER_SERVICE, "0.0.1", TRUE,
            NULL);

    if (osso_context == NULL) {
        return OSSO_ERROR;
    }

    program = HILDON_PROGRAM(hildon_program_get_instance());
    appdata = g_new0(AppData, 1);
    appdata->program = program;
    appdata->osso_context = osso_context;

    if (osso_rpc_set_cb_f(osso_context, "com.nokia.widgetinstaller",
            "/com/nokia/widgetinstaller", "com.nokia.widgetinstaller",
            dbus_handler, appdata) != OSSO_OK) {
        g_printerr("Failed to set callback\n");
    }

    gtk_main();
    osso_deinitialize(osso_context);
    return 0;
}
