/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef HOMESCREENVIEW_H
#define HOMESCREENVIEW_H

#include <QWidget>

namespace WRT {

class WrtPage;

namespace Maemo {

class HomeScreenView : public QWidget
{
    Q_OBJECT

public:
    HomeScreenView(const QString& id, QWidget* parent = 0);
    virtual ~HomeScreenView();

    virtual void setPage(WrtPage* page);
    virtual void freeze();
    virtual void restore();

    bool isVisible();

signals:
    void clicked();
    void visibilityChanged(bool visible);

protected:
    void showEvent(QShowEvent* event);
    void hideEvent(QHideEvent* event);
    bool x11Event(XEvent* event);
    void paintEvent(QPaintEvent* event);

    WrtPage* m_page;
    QPixmap* m_snapShot;
    QColor m_disabledColor;

private:
    void setHildonAppletWindowType();
    void setHildonAppletId(const QString& id);
    void notifyVisibilityChanged(bool visible);

    bool m_visible;
};

}
}

#endif // HOMESCREENVIEW_H
