/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _WIDGET_MANAGER_CONSTANTS_H_
#define _WIDGET_MANAGER_CONSTANTS_H_

#include <QDir>

#define CONTENT_TYPE_WGZ "application/x-nokia-widget"
#define CONTENT_TYPE_WGT "application/widget"
#define CONTENT_TYPE_UNKNOWN "Unknown"

#define EXTENSION_WGZ ".wgz"
#define EXTENSION_WGT ".wgt"

#define WIDGET_PACKAGE_FORMAT_WGT "w3c-partial-v1"
#define WIDGET_PACKAGE_FORMAT_WGZ "wgz"
#define WIDGET_PACKAGE_FORMAT_SHARED_LIBRARY "shared-library"
#define WIDGET_PACKAGE_FORMAT_JIL "jil"

const char WIDGET_PACKAGE_MAGIC_NUMBER_WGT[] = {0x50, 0x4B, 0x03, 0x04};

#ifdef CWRT_WIDGET_FILES_IN_SECURE_STORAGE
const QString WIDGET_STORAGE("WidgetsSecureStore");
#endif

const QString WIDGET_FOLDER("widgets_21D_4C7");
const QString SHARED_LIBRARY_FOLDER("lib");

static const char DATA_FOLDER[]        = "data";
static const char SECSESSION_FILE[]         = "secsession";

#if defined(Q_OS_SYMBIAN)
const QString DEFAULT_ROOT_DIRECTORY("C:/Private/200267C0");
const QString DEFAULT_DIRECTORY("200267C0");
const QString PRIVATE_DIRECTORY(":/Private");
const QString SHARED_LIBRARY_PATH = ("C:\\Private\\200267C0\\"+WIDGET_FOLDER+"\\"+SHARED_LIBRARY_FOLDER+"\\");
const QString DATA_PATH("C:\\Private\\200267C0\\"+ QString(DATA_FOLDER) + "\\");
const QString INI_PATH("C:\\Private\\102829CB\\multiprocini\\multiprocsettings.ini");
#elif defined(Q_OS_MAEMO6) || defined(Q_OS_MAEMO5)

/* Maemo directories:
 *   /usr/share/wrt/data/resources           -- widget resources directory
 *   /usr/share/wrt/data/widgets_21D_4C7     -- widget installation directory
 *   /usr/share/wrt/data/widgets_21D_4C7/lib -- shared JS libraries
 */
const QString DEFAULT_ROOT_DIRECTORY = QString("/usr/share/wrt/data/");
const QString WIDGET_INSTALL_PATH = DEFAULT_ROOT_DIRECTORY + WIDGET_FOLDER + QString("/");
const QString SHARED_LIBRARY_PATH = WIDGET_INSTALL_PATH + SHARED_LIBRARY_FOLDER + QString("/");
const QString DATA_PATH = DEFAULT_ROOT_DIRECTORY + DATA_FOLDER + QString("/");

#else
#include <QDesktopServices>
const QString DEFAULT_ROOT_DIRECTORY = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
const QString SHARED_LIBRARY_PATH = DEFAULT_ROOT_DIRECTORY+QDir::separator()+WIDGET_FOLDER+QDir::separator()+SHARED_LIBRARY_FOLDER+QDir::separator();
const QString DATA_PATH(DEFAULT_ROOT_DIRECTORY+QDir::separator()+ QString(DATA_FOLDER) +QDir::separator());
#endif

#if defined(Q_OS_MAEMO6) || defined(Q_OS_MAEMO5)
const QString CERTIFICATE_PATH("/etc/certs/codesigning");
#endif

#endif // _WIDGET_MANAGER_CONSTANTS_H_
