# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
QT += xml sql
CONFIG += dll link_prl create_prl

ROOT_DIR = $$PWD/../../..
WRT_DIR = $$ROOT_DIR/wrt
include($$ROOT_DIR/wrt/wrt.pri)
include($$ROOT_DIR/wrt/cwrt.pri)
include($$ROOT_DIR/wrt/translation.pri)
include($$ROOT_DIR/wrt/utilities/CertificateManager/CertificateManager.pri)
include($$ROOT_DIR/wrt/utilities/W3CWidgetVerifier/W3CWidgetVerifier.pri)

DEFINES *=BUILDING_WIDGETUTILS_LIB
include (../../3rdparty/zlib/zlib.pri)

INCLUDEPATH += \
    $$PWD \
    $$PWD/private \
    $$PWD/resource  \
    $$PWD/W3CXmlParser \
    $$PWD/../../3rdparty/zlib \
    $$PWD/../../runtimecore \
    $$PWD/../../securestorage \
    $$PWD/../../securestorage/platform/qt \
    $$PWD/../../securestorage/platform/qt/securestorageclient \
    $$PWD/../../security \
    $$PWD/../../services-tmp/WebServices \
    $$PWD/../../settings/inc \
    $$PWD/../../utilities/W3CWidgetVerifier

HEADERS += \
    $$PWD/private/WidgetUtilsLogs.h \
    $$PWD/private/WidgetLinkResolver.h \
    $$PWD/private/WidgetPListParser.h \
    $$PWD/private/webappmanager_p.h \
    $$PWD/AttributeMap.h \
    $$PWD/PropertyNames.h \
    $$PWD/WidgetManager.h \
    $$PWD/WidgetProperties.h \
    $$PWD/WebAppRegistry.h \
    $$PWD/private/WidgetInfo.h \
    $$PWD/W3CXmlParser/w3ctags.h \
    $$PWD/W3CXmlParser/w3celement.h \
    $$PWD/W3CXmlParser/w3cxmlplugin.h \
    $$PWD/W3CXmlParser/w3csettingskeys.h \
    $$PWD/W3CXmlParser/configw3xmlparser.h \
    $$PWD/SuperWidget.h \
    $$PWD/WgzWidget.h \
    $$PWD/WgtWidget.h \
    $$PWD/AsyncInstall.h \
    $$PWD/InstallWorker.h \
    $$PWD/widgetinstaller.h \
    $$PWD/featuremapping.h

SOURCES += \
    $$PWD/private/WidgetLinkResolver.cpp \
    $$PWD/private/WidgetPListParser.cpp \
    $$PWD/WidgetManager.cpp \
    $$PWD/WebAppRegistry.cpp \
    $$PWD/W3CXmlParser/w3celement.cpp \
    $$PWD/W3CXmlParser/w3cxmlplugin.cpp \
    $$PWD/W3CXmlParser/configw3xmlparser.cpp \
    $$PWD/SuperWidget.cpp \
    $$PWD/WgzWidget.cpp \
    $$PWD/WgtWidget.cpp \
    $$PWD/AsyncInstall.cpp \
    $$PWD/InstallWorker.cpp \
    $$PWD/widgetinstaller.cpp \
    $$PWD/featuremapping.cpp

RESOURCES += $$PWD/resources.qrc

DEFINES += SHA256_SUPPORT

CONFIG += link_pkgconfig

SOURCES -= $$PWD/widgetinstaller.cpp
SOURCES -= $$PWD/WgzWidget.cpp
SOURCES += $$PWD/platform/maemo/widgetinstaller.cpp
SOURCES += $$PWD/platform/maemo/widgetinstaller_p.cpp
HEADERS -= $$PWD/WgzWidget.h
HEADERS += $$PWD/platform/maemo/widgetinstaller_p.h

headers.files = \
    $$PWD/AttributeMap.h \
    $$PWD/PropertyNames.h \
    $$PWD/WidgetManager.h \
    $$PWD/WidgetProperties.h \
    $$PWD/WebAppRegistry.h \
    $$PWD/SuperWidget.h \
    $$PWD/WgtWidget.h \
    $$PWD/AsyncInstall.h \
    $$PWD/InstallWorker.h \
    $$PWD/widgetinstaller.h \
    $$PWD/featuremapping.h
headers.path = $$CWRT_INSTALL_INC_DIR/wrt/widgetmanager/src

headers_platform_qt.files = $$PWD/platform/qt/WidgetRegistrationQt.h
headers_platform_qt.path = $$CWRT_INSTALL_INC_DIR/wrt/widgetmanager/src/platform/qt

headers_w3cxmlparser.files = \
    $$PWD/W3CXmlParser/w3ctags.h \
    $$PWD/W3CXmlParser/w3celement.h \
    $$PWD/W3CXmlParser/w3cxmlplugin.h \
    $$PWD/W3CXmlParser/w3csettingskeys.h \
    $$PWD/W3CXmlParser/configw3xmlparser.h
headers_w3cxmlparser.path = $$CWRT_INSTALL_INC_DIR/wrt/widgetmanager/src/W3CXmlParser

headers_private.files = \
    $$PWD/private/WidgetUtilsLogs.h \
    $$PWD/private/WidgetLinkResolver.h \
    $$PWD/private/WidgetPListParser.h \
    $$PWD/private/webappmanager_p.h
headers_private.path = $$CWRT_INSTALL_INC_DIR/wrt/widgetmanager/src/private

mapping.path = $$CWRT_POLICY_DIR
mapping.files = $$PWD/resource/mapping.xml

INSTALLS += mapping headers headers_platform_qt headers_w3cxmlparser headers_private

TARGET = WrtWidgetUtils
LIBS += -lWrtSecureStorage -lWrtSecurityManager -lWrtSettings -lssl

# What should be right folder for this helper script
debianWrapperScript.path = $$CWRT_INSTALL_BIN_DIR
debianWrapperScript.files = $$ROOT_DIR/tools/scripts/createdeb.sh

INSTALLS += debianWrapperScript
PKGCONFIG += dbus-1 libhildonmime glib-2.0
