/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "widgetinstaller.h"
#include "widgetinstaller_p.h"
#include "SuperWidget.h"
#include "storage.h"
#include "w3csettingskeys.h"


WidgetInstaller::WidgetInstaller(SuperWidget * webWidget, WRT::Storage * storage) {
    d = new WidgetInstallerPrivate(webWidget, storage);
}

WidgetInstaller::~WidgetInstaller() {
    delete d;
}

bool WidgetInstaller::install(QDir source, QDir target, QString appId) {
    // TODO : appId should be writen to desktop file so that
    // during runtime the metadata of the widget is possible to read from WebAppRegistry
    // TODO : debian package name should be stored to WebAppRegistry if installation is successful, so that
    // WidgetManager can uninstall it. (Code in comments in below)

    QString desktopfilePath;
    WidgetInstallerPrivate::InstallationStatus status =
      d->install(source.absolutePath(), target.absolutePath(),
                 appId, desktopfilePath);

#ifdef DEBUG
    qWarning() << "\n**********************************************************************************************";
    switch (status) {
        case WidgetInstallerPrivate::Success:
            qWarning() << Q_FUNC_INFO << "Debian install status: Success";
            break;
        case WidgetInstallerPrivate::DebianPackageStructureCreationFailed:
            qWarning() << Q_FUNC_INFO << "Debian install status: DebianPackageStructureCreationFailed";
            break;
        case WidgetInstallerPrivate::DebianPackageCreationFailed:
            qWarning() << Q_FUNC_INFO << "Debian install status: DebianPackageCreationFailed";
            break;
        case WidgetInstallerPrivate::DebianPackageInstallationFailed:
            qWarning() << Q_FUNC_INFO << "Debian install status: DebianPackageInstallationFailed";
            break;
        case WidgetInstallerPrivate::WebWidgetSecureStoringFailed:
            qWarning() << Q_FUNC_INFO << "Debian install status: WebWidgetSecureStoringFailed";
            break;
        default:
            qWarning() << Q_FUNC_INFO << "Debian install status: unknown reason: " << status;
            break;
    }
    qWarning() << "**********************************************************************************************\n";
#endif

    if (status == WidgetInstallerPrivate::Success) {
        m_nativeId = desktopfilePath;
        //WebAppRegistry::instance()->setWebAppAttribute(appId, "debFile", d->debianFile());
        return true;
    } else {
        return false;
    }
}

bool WidgetInstaller::update(QDir source, QDir target, QString appId) {
    return install(source, target, appId);
}

bool WidgetInstaller::uninstall(QString applicationPath, QString appId) {
    Q_UNUSED(applicationPath)
    return WidgetInstallerPrivate::uninstall(appId);
}

QString WidgetInstaller::nativeId() {
    return m_nativeId;
}
