/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef JSWIDGETINTERFACE_P_H_
#define JSWIDGETINTERFACE_P_H_

#include <QObject>
#include <QString>

#include "jsresourcewrapper.h"

class QWebPage;

namespace WRT {

class JSResourceWrapperPrivate: QObject {
Q_OBJECT
public:
    JSResourceWrapperPrivate(QString jsResource, QString jsObjectName, JSResourceWrapper::JavaScriptHandling javaScriptHandling);
    ~JSResourceWrapperPrivate();

    void setWebPage(QWebPage* page);
    QString name();

private Q_SLOTS:
    void eval();

private:
    QWebPage * m_page;
    QString m_jsResource;
    QString m_jsObjectName;
    int m_loadCount;
    JSResourceWrapper::JavaScriptHandling m_jsHandling;

    friend class JSResourceWrapper;

};

}

#endif /* JSWIDGETINTERFACE_P_H_ */
