/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "jsmenuitemfactory.h"
#include "jsmenuitem.h"
#include "action.h"

#include <QWebPage>
#include <QWebFrame>
#include <QDebug>

namespace WRT {

QMap<int, JSMenuItem*> JSMenuItemFactory::s_menuItems;

/*!
    \class WRT::JSMenuItemFactory
    \brief The WRT::JSMenuItemFactory is factory class for creating native instance of menu items from JavaScript that
    are exposed to JavaScript window object.

    \inmodule WidgetCore

    WRT::JSMenuItemFactory is used for creating WRT::JSMenuItem instances of from JavaScript. Constructor of
    nokia.device.MenuItem is responsible of keeping track native instance handles.

    In addition, WRT::JSMenuItemFactory evaluates menuitem.js (nokia.device.MenuItem) resource file to current frame.
*/

/*!
    Constructs an instance of JSMenuItem with expose name \a exposeName
*/
JSMenuItemFactory::JSMenuItemFactory()
    : JSResourceWrapper("menuitem.js", "menuItemFactoryCPP")
    , m_id(0) {
}

JSMenuItemFactory::~JSMenuItemFactory() {

}

/*!
    Creates an instance of WRT::JSMenuItem and returns a instance handle to JavaScript.
    Constructor of nokia.device.MenuItem is responsible of keeping track of native instance handles.
*/
int JSMenuItemFactory::createMenuItem() {
    // TODO : JSMenuItems
    // This might be a problem. Who would lease native instance?
    QString uniqueId = QString("tmpMenuItemFactoryCPPMenuItem");
    JSMenuItem* item = new JSMenuItem(uniqueId);
    item->action()->setId(m_id);
    QWebPage* page = webPage();
    item->setWebPage(page);
    item->addToJavaScriptWindowObject();
    int itemId = m_id;
    s_menuItems.insert(itemId, item);

    connect(page->mainFrame(), SIGNAL(javaScriptWindowObjectCleared()), item, SLOT(addToJavaScriptWindowObject()));
    ++m_id;
    return itemId;
}

JSMenuItem* JSMenuItemFactory::item(int id) {
    return s_menuItems.value(id);
}

}
